/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.commands;

import com.mcbans.plugin.BanType;
import com.mcbans.plugin.I18n;
import com.mcbans.plugin.commands.BaseCommand;
import com.mcbans.plugin.exception.CommandException;
import com.mcbans.plugin.org.json.JSONObject;
import com.mcbans.plugin.permission.Perms;
import com.mcbans.plugin.request.Ban;
import com.mcbans.plugin.util.Util;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;

public class CommandRban
extends BaseCommand {
    public CommandRban() {
        this.bePlayer = false;
        this.name = "rban";
        this.argLength = 1;
        this.usage = "ban a player and rollback their block changes";
        this.banning = true;
    }

    @Override
    public void execute() throws CommandException {
        this.args.remove(0);
        BanType type = BanType.LOCAL;
        if (this.args.size() > 0) {
            if (((String)this.args.get(0)).equalsIgnoreCase("g")) {
                type = BanType.GLOBAL;
            } else if (((String)this.args.get(0)).equalsIgnoreCase("t")) {
                type = BanType.TEMP;
            }
        }
        if (type != BanType.LOCAL) {
            this.args.remove(0);
        }
        if (!type.getPermission().has((Permissible)this.sender)) {
            throw new CommandException(ChatColor.RED + I18n.localize("permissionDenied", new Object[0]));
        }
        if (!this.plugin.getRbHandler().hasRollbackMethod()) {
            throw new CommandException(ChatColor.RED + I18n.localize("rbMethodNotFound", new Object[0]));
        }
        String reason = null;
        Ban banControl = null;
        switch (type) {
            case LOCAL: {
                reason = this.config.getDefaultLocal();
                if (this.args.size() > 0) {
                    reason = Util.join(this.args, " ");
                }
                banControl = new Ban(this.plugin, type.getActionName(), this.target, this.targetUUID, this.targetIP, this.senderName, this.senderUUID, reason, "", "", new JSONObject(), true);
                break;
            }
            case GLOBAL: {
                if (this.args.size() == 0) {
                    Util.message(this.sender, ChatColor.RED + I18n.localize("formatError", new Object[0]));
                    return;
                }
                reason = Util.join(this.args, " ");
                banControl = new Ban(this.plugin, type.getActionName(), this.target, this.targetUUID, this.targetIP, this.senderName, this.senderUUID, reason, "", "", new JSONObject(), true);
                break;
            }
            case TEMP: {
                if (this.args.size() <= 2) {
                    Util.message(this.sender, ChatColor.RED + I18n.localize("formatError", new Object[0]));
                    return;
                }
                String measure = "";
                String duration = (String)this.args.remove(0);
                if (!duration.matches("(?sim)([0-9]+)(minute(s|)|m|hour(s|)|h|day(s|)|d|week(s|)|w)")) {
                    measure = (String)this.args.remove(0);
                } else {
                    try {
                        Pattern regex = Pattern.compile("([0-9]+)(minute(s|)|m|hour(s|)|h|day(s|)|d|week(s|)|w)", 106);
                        Matcher regexMatcher = regex.matcher(duration);
                        if (regexMatcher.find()) {
                            duration = regexMatcher.group(1);
                            measure = regexMatcher.group(2);
                        }
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        // empty catch block
                    }
                }
                reason = this.config.getDefaultTemp();
                if (this.args.size() > 0) {
                    reason = Util.join(this.args, " ");
                }
                banControl = new Ban(this.plugin, type.getActionName(), this.target, this.targetUUID, this.targetIP, this.senderName, this.senderUUID, reason, duration, measure, new JSONObject(), true);
            }
        }
        if (banControl == null) {
            Util.message(this.sender, ChatColor.RED + "Internal error! Please report console logs!");
            throw new RuntimeException("Undefined BanType: " + type.name());
        }
        banControl.run();
    }

    @Override
    public boolean permission(CommandSender sender) {
        return Perms.BAN_ROLLBACK.has((Permissible)sender);
    }
}

