/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.commands;

import com.mcbans.plugin.I18n;
import com.mcbans.plugin.callBacks.ManualResync;
import com.mcbans.plugin.callBacks.ManualSync;
import com.mcbans.plugin.callBacks.MessageCallback;
import com.mcbans.plugin.callBacks.ServerChoose;
import com.mcbans.plugin.commands.BaseCommand;
import com.mcbans.plugin.exception.CommandException;
import com.mcbans.plugin.permission.Perms;
import com.mcbans.plugin.request.PingRequest;
import com.mcbans.plugin.util.Util;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class CommandMcbans
extends BaseCommand {
    public CommandMcbans() {
        this.bePlayer = false;
        this.name = "mcbans";
        this.argLength = 0;
        this.usage = "show information";
        this.banning = false;
    }

    @Override
    public void execute() throws CommandException {
        if (this.args.size() == 0) {
            this.send("&bMCBans &3" + this.plugin.getDescription().getVersion() + "&b Help &f|| &b<> &f= required, &b[] &f= optional");
            this.send("&f/mcbans banning" + ChatColor.BLUE + " Help with banning/unbanning commands");
            this.send("&f/mcbans user" + ChatColor.BLUE + " Help with user management commands");
            this.send("&f/mcbans perms" + ChatColor.BLUE + " Permission list for MCBans");
            this.send("&f/mcbans get" + ChatColor.BLUE + " Get time till next API call");
            this.send("&f/mcbans ping" + ChatColor.BLUE + " Check overall response time from API");
            this.send("&f/mcbans sync" + ChatColor.BLUE + " Force a sync to occur with MCBans API");
            this.send("&f/mcbans reload" + ChatColor.BLUE + " Reload settings and language files");
            return;
        }
        String first = (String)this.args.remove(0);
        if (first.equalsIgnoreCase("banning")) {
            this.send("&f------------------------------------------");
            this.send("&f/ban <name|uuid> [reason]" + ChatColor.BLUE + " Local ban a player");
            this.send("&f/ban <name|uuid> -g <reason>" + ChatColor.BLUE + " Global ban a player");
            this.send("&f/ban <name|uuid> -t <time> <m, h, d, w> <reason>" + ChatColor.BLUE + " Temporarily ban a player");
            this.send("&f/tban <name|uuid> <time> <m(minute), h(hour), d(day), w(week)> [reason]" + ChatColor.BLUE + " Temp ban a player");
            this.send("&f/gban <name|uuid> <reason>" + ChatColor.BLUE + " Global ban a player");
            this.send("&f/rban <name|uuid> [reason]" + ChatColor.BLUE + " Rollback and local ban a player");
            this.send("&f/rban <name|uuid> -g <reason>" + ChatColor.BLUE + " Rollback and global ban a player");
            this.send("&f/rban <name|uuid> -t <time> <m, h, d, w> <reason>" + ChatColor.BLUE + " Rollback and temporarily ban a player");
            this.send("&f/banip <ip> [reason]" + ChatColor.BLUE + " Bans an IP address");
            this.send("&f/unban <name|ip|uuid>" + ChatColor.BLUE + " Bans an IP address");
            return;
        }
        if (first.equalsIgnoreCase("user")) {
            this.send("&f------------------------------------------");
            this.send("&f/lookup <name|uuid>" + ChatColor.BLUE + " Lookup the player ban information");
            this.send("&f/banlookup <banID>" + ChatColor.BLUE + " Lookup the player ban information");
            this.send("&f/altlookup <name>" + ChatColor.BLUE + " Lookup the alt account information");
            this.send("&f/kick <name> [reason]" + ChatColor.BLUE + " Kick player from the server");
            return;
        }
        if (first.equalsIgnoreCase("perms")) {
            this.send("&f------------------------------------------");
            if (this.args.size() == 0) {
                this.send("&f/mcbans perms ban" + ChatColor.BLUE + " Banning/kick permissions");
                this.send("&f/mcbans perms exempt" + ChatColor.BLUE + " Exemptions from kick/ban");
                this.send("&f/mcbans perms view" + ChatColor.BLUE + " On connect bans/bans/alts");
                this.send("&f/mcbans perms others" + ChatColor.BLUE + " Lookups");
                this.send(ChatColor.GOLD + "mcbans.admin" + ChatColor.BLUE + " Grants complete MCBans admin permission");
                return;
            }
            String last = (String)this.args.remove(0);
            if (last.equalsIgnoreCase("ban")) {
                this.send(ChatColor.GOLD + "mcbans.ban.global" + ChatColor.BLUE + " Grants global ban permissions");
                this.send(ChatColor.GOLD + "mcbans.ban.local" + ChatColor.BLUE + " Grants local ban permissions");
                this.send(ChatColor.GOLD + "mcbans.ban.temp" + ChatColor.BLUE + " Grants temporary ban permissions");
                this.send(ChatColor.GOLD + "mcbans.ban.rollback" + ChatColor.BLUE + " Grants rollback ban permissions");
                this.send(ChatColor.GOLD + "mcbans.ban.ip" + ChatColor.BLUE + " Grants IP ban permissions");
                this.send(ChatColor.GOLD + "mcbans.unban" + ChatColor.BLUE + " Grants unban permissions");
                this.send(ChatColor.GOLD + "mcbans.kick" + ChatColor.BLUE + " Grants kick permissions");
                return;
            }
            if (last.equalsIgnoreCase("view")) {
                this.send(ChatColor.GOLD + "mcbans.view.alts" + ChatColor.BLUE + " View players alts on connect {premium only}");
                this.send(ChatColor.GOLD + "mcbans.view.bans" + ChatColor.BLUE + " View players bans on connect");
                this.send(ChatColor.GOLD + "mcbans.view.staff" + ChatColor.BLUE + " View if player is MCBans Staff on connect");
                this.send(ChatColor.GOLD + "mcbans.view.previous" + ChatColor.BLUE + " View players previous names on connect");
                this.send(ChatColor.GOLD + "mcbans.announce" + ChatColor.BLUE + " View if the player is banned/kicked");
                return;
            }
            if (last.equalsIgnoreCase("exempt")) {
                this.send(ChatColor.GOLD + "mcbans.kick.exempt" + ChatColor.BLUE + " Player cannot be kicked at all");
                this.send(ChatColor.GOLD + "mcbans.ban.exempt" + ChatColor.BLUE + " Player cannot be banned at all");
                return;
            }
            if (last.equalsIgnoreCase("others")) {
                this.send(ChatColor.GOLD + "mcbans.lookup.player" + ChatColor.BLUE + " Grants lookup player command");
                this.send(ChatColor.GOLD + "mcbans.lookup.ban" + ChatColor.BLUE + " Grants lookup ban command");
                this.send(ChatColor.GOLD + "mcbans.lookup.alt" + ChatColor.BLUE + " Grants lookup alternate accounts command");
                return;
            }
            return;
        }
        if (first.equalsIgnoreCase("ping")) {
            if (!Perms.ADMIN.has((Permissible)this.sender)) {
                throw new CommandException(ChatColor.RED + I18n.localize("permissionDenied", new Object[0]));
            }
            PingRequest request = new PingRequest(this.plugin, new MessageCallback(this.plugin, this.sender));
            new Thread(request).start();
            return;
        }
        if (first.equalsIgnoreCase("sync")) {
            if (!Perms.ADMIN.has((Permissible)this.sender)) {
                throw new CommandException(ChatColor.RED + I18n.localize("permissionDenied", new Object[0]));
            }
            if (this.args.size() > 0 && ((String)this.args.get(0)).equalsIgnoreCase("all")) {
                this.send(ChatColor.GREEN + "Resyncing with MCBans API!");
                ManualResync manualSyncBanRunner = new ManualResync(this.plugin, this.senderName);
                new Thread(manualSyncBanRunner).start();
            } else {
                long ht;
                long syncInterval = 60 * this.config.getSyncInterval();
                if (syncInterval < 3600L) {
                    syncInterval = 3600L;
                }
                if ((ht = this.plugin.lastSync + syncInterval - System.currentTimeMillis() / 1000L) > 10L) {
                    this.send(ChatColor.GREEN + "Sync has started. This will take a few moments to complete.");
                    ManualSync manualSyncBanRunner = new ManualSync(this.plugin, this.senderName);
                    new Thread(manualSyncBanRunner).start();
                } else {
                    throw new CommandException(ChatColor.RED + "Sync will occur in less than 10 seconds.");
                }
            }
            return;
        }
        if (first.equalsIgnoreCase("get")) {
            if (this.args.size() > 0 && ((String)this.args.get(0)).equalsIgnoreCase("call")) {
                String remainStr;
                long callBackInterval = 0L;
                callBackInterval = 60 * this.config.getCallBackInterval();
                if (callBackInterval < 900L) {
                    callBackInterval = 900L;
                }
                if ((remainStr = this.timeRemain(this.plugin.lastCallBack + callBackInterval - System.currentTimeMillis() / 1000L)) != null) {
                    this.send(ChatColor.GOLD + remainStr + " until next callback request.");
                } else {
                    this.send(ChatColor.GOLD + "Callback request is in progress...");
                }
            } else if (this.args.size() > 0 && ((String)this.args.get(0)).equalsIgnoreCase("sync")) {
                if (this.config.isEnableAutoSync()) {
                    String remainStr;
                    long syncInterval = 60 * this.config.getSyncInterval();
                    if (syncInterval < 300L) {
                        syncInterval = 300L;
                    }
                    if ((remainStr = this.timeRemain(this.plugin.lastSync + syncInterval - System.currentTimeMillis() / 1000L)) != null) {
                        this.send(ChatColor.GOLD + remainStr + " until next sync.");
                    } else {
                        this.send(ChatColor.GOLD + "Ban sync is in progress...");
                    }
                } else {
                    this.send(ChatColor.RED + "Auto sync is disabled by config.yml!");
                }
            } else {
                this.send(ChatColor.WHITE + "/mcbans get call" + ChatColor.BLUE + " Time until callback thread sends data.");
                this.send(ChatColor.WHITE + "/mcbans get sync" + ChatColor.BLUE + " Time until next sync.");
            }
            return;
        }
        if (first.equalsIgnoreCase("reload")) {
            if (!Perms.ADMIN.has((Permissible)this.sender)) {
                throw new CommandException(ChatColor.RED + I18n.localize("permissionDenied", new Object[0]));
            }
            this.send(ChatColor.AQUA + "Reloading configuration...");
            try {
                this.config.loadConfig(false);
                this.send(ChatColor.GREEN + "Reload complete.");
            }
            catch (Exception ex) {
                this.send(ChatColor.RED + "An error occurred while trying to load the config file.");
            }
            this.send(ChatColor.AQUA + "Reloading language file...");
            try {
                I18n.extractLanguageFiles(false);
                I18n.setCurrentLanguage(this.config.getLanguage());
                this.send(ChatColor.GREEN + "Reload complete.");
            }
            catch (Exception ex) {
                this.send(ChatColor.RED + "An error occurred while trying to load the language file.");
            }
            ServerChoose serverChooser = new ServerChoose(this.plugin);
            new Thread(serverChooser).start();
            return;
        }
        if (first.equalsIgnoreCase("staff") && this.player != null && this.plugin.mcbStaff.contains(this.player.getName())) {
            if (this.args.size() > 0 && ((String)this.args.get(0)).equalsIgnoreCase("perms")) {
                this.send("&6-=== All Online Players Perms ===-");
                for (Perms perm : Perms.values()) {
                    this.send("&6" + perm.getNode() + ": &e" + Util.join(perm.getPlayerNames(), ", "));
                }
            } else if (this.args.size() > 0 && ((String)this.args.get(0)).equalsIgnoreCase("debug")) {
                this.send("&6-=== Debug Information ===-");
                this.send("&6Spigot Version: &e" + Bukkit.getVersion());
                this.send("&6Build: &e" + Bukkit.getBukkitVersion());
                this.send("&6connData.size: &e" + this.plugin.connectionData.size() + "&6 pCache.size: &e" + this.plugin.playerCache.size() + "&6 resetTime.size: &e" + this.plugin.resetTime.size());
                this.send("&6ApiServer: &e" + this.plugin.apiServer + " &6last_req: &e" + this.plugin.last_req + " &6last_sync: &e" + this.plugin.lastSync);
                this.send("&6timeRecieved: &e" + this.plugin.timeRecieved + " &6syncRunning: &e" + this.plugin.syncRunning + " &6lastID: &e" + this.plugin.lastID);
                this.send("&6NCP: &e" + this.plugin.isEnabledNCP() + " &6AC: &e" + this.plugin.isEnabledAC());
            } else if (this.args.size() > 0 && ((String)this.args.get(0)).equalsIgnoreCase("verify")) {
                Util.message((CommandSender)Bukkit.getConsoleSender(), ChatColor.AQUA + this.player.getName() + " is an MCBans staff member.");
                Set<Player> players = Perms.VIEW_STAFF.getPlayers();
                players.addAll(Perms.ADMIN.getPlayers());
                players.addAll(Perms.BAN_GLOBAL.getPlayers());
                for (Player p : players) {
                    Util.message((CommandSender)p, ChatColor.AQUA + I18n.localize("isMCBansMod", "%PLAYER%", this.player.getName()));
                }
            } else {
                this.send("&6-=== Server Settings ===-");
                this.send("&6Valid API Key: &e" + this.config.isValidApiKey() + "&6 Permissions: &e" + this.config.getPermission());
                this.send("&6MinRep: &e" + this.config.getMinRep() + "&6 AutoSync: &e" + this.config.isEnableAutoSync());
                this.send("&6Max Alts: &e" + this.config.isEnableMaxAlts() + " (" + this.config.getMaxAlts() + ")");
                this.send("&6Failsafe: &e" + this.config.isFailsafe() + "&6 isDebug: &e" + this.config.isDebug() + "&6 Log: &e" + this.config.isEnableLog());
                this.send("&6-=== Server Status ===-");
                this.send("&6MCBans Plugin: &e" + this.plugin.getDescription().getVersion());
                this.send("&6Name: &e" + Bukkit.getServer().getName() + "&6 IP: &e" + Bukkit.getServer().getIp() + ":" + Bukkit.getServer().getPort());
                this.send("&6OnlineMode: &e" + Bukkit.getOnlineMode());
                this.send("&6-=== Online Players ===-");
                this.send("&6mcbans.admin: &e" + Util.join(Perms.ADMIN.getPlayerNames(), ", "));
                this.send("&6mcbans.ban.global: &e" + Util.join(Perms.BAN_GLOBAL.getPlayerNames(), ", "));
            }
            return;
        }
        throw new CommandException(ChatColor.RED + I18n.localize("formatError", new Object[0]));
    }

    private void send(String msg) {
        Util.message(this.sender, Util.color(msg));
    }

    private String timeRemain(long remain) {
        if (remain <= 0L) {
            return null;
        }
        try {
            String format = "";
            long timeRemaining = remain;
            long sec = timeRemaining % 60L;
            long min = timeRemaining / 60L % 60L;
            long hours = timeRemaining / 3600L % 24L;
            long days = timeRemaining / 86400L % 7L;
            long weeks = timeRemaining / 604800L;
            if (sec != 0L) {
                format = sec + " seconds";
            }
            if (min != 0L) {
                format = min + " minutes " + format;
            }
            if (hours != 0L) {
                format = hours + " hours " + format;
            }
            if (days != 0L) {
                format = days + " days " + format;
            }
            if (weeks != 0L) {
                format = weeks + " weeks " + format;
            }
            return format;
        }
        catch (ArithmeticException e) {
            if (this.config.isDebug()) {
                e.printStackTrace();
            }
            return "error";
        }
    }

    @Override
    public boolean permission(CommandSender sender) {
        return true;
    }
}

