/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.commands;

import com.mcbans.plugin.I18n;
import com.mcbans.plugin.callBacks.MessageCallback;
import com.mcbans.plugin.commands.BaseCommand;
import com.mcbans.plugin.exception.CommandException;
import com.mcbans.plugin.permission.Perms;
import com.mcbans.plugin.request.BanIpRequest;
import com.mcbans.plugin.util.Util;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;

public class CommandBanip
extends BaseCommand {
    public CommandBanip() {
        this.bePlayer = false;
        this.name = "banip";
        this.argLength = 1;
        this.usage = "ban an IP address";
        this.banning = true;
    }

    @Override
    public void execute() throws CommandException {
        this.args.remove(0);
        String reason = this.config.getDefaultLocal();
        if (this.args.size() > 0) {
            reason = Util.join(this.args, " ");
        }
        if (!Util.isValidIP(this.target)) {
            throw new CommandException(ChatColor.RED + I18n.localize("invalidIP", new Object[0]));
        }
        BanIpRequest request = new BanIpRequest(this.plugin, new MessageCallback(this.plugin, this.sender), this.target, reason, this.senderName, this.senderUUID);
        request.run();
    }

    @Override
    public boolean permission(CommandSender sender) {
        return Perms.BAN_IP.has((Permissible)sender);
    }
}

