/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.commands;

import com.mcbans.plugin.ConfigurationManager;
import com.mcbans.plugin.I18n;
import com.mcbans.plugin.MCBans;
import com.mcbans.plugin.exception.CommandException;
import com.mcbans.plugin.util.Util;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class BaseCommand {
    protected MCBans plugin;
    protected ConfigurationManager config;
    protected CommandSender sender;
    protected String command;
    protected List<String> args = new ArrayList<String>();
    protected String senderName;
    protected String senderUUID;
    protected Player player;
    protected boolean isPlayer;
    protected String target = "";
    protected String targetIP = "";
    protected String targetUUID = "";
    protected String name;
    protected int argLength = 0;
    protected String usage;
    protected boolean bePlayer = false;
    protected boolean banning = false;

    public boolean run(MCBans plugin, CommandSender sender, String cmd, String[] preArgs) {
        if (this.name == null) {
            Util.message(sender, "&cThis command has not been loaded properly.");
            return true;
        }
        this.init();
        this.plugin = plugin;
        this.config = plugin.getConfigs();
        this.sender = sender;
        this.command = cmd;
        for (String arg : preArgs) {
            this.args.add(arg);
        }
        if (this.argLength > this.args.size()) {
            Util.message(sender, ChatColor.RED + I18n.localize("formatError", new Object[0]));
            return true;
        }
        if (this.bePlayer && !(sender instanceof Player)) {
            Util.message(sender, "&cThis command cannot be executed from the console.");
            return true;
        }
        if (sender instanceof Player) {
            this.player = (Player)sender;
            this.senderName = this.player.getName();
            this.isPlayer = true;
        }
        if (!this.permission(sender)) {
            Util.message(sender, ChatColor.RED + I18n.localize("permissionDenied", new Object[0]));
            return true;
        }
        if (this.banning && this.args.size() > 0) {
            this.target = this.args.get(0).trim();
            Player targetPlayer = Bukkit.getPlayerExact((String)this.target);
            if (targetPlayer != null && targetPlayer.isOnline()) {
                InetSocketAddress socket = targetPlayer.getAddress();
                this.targetIP = socket.isUnresolved() ? socket.getHostString() : socket.getAddress().getHostAddress();
            }
            if (!Util.isValidName(this.target)) {
                if (Util.isValidUUID(this.target)) {
                    this.targetUUID = this.target;
                    this.target = "";
                } else if (Util.isValidIP(this.target)) {
                    this.targetIP = this.target;
                } else {
                    Util.message(sender, ChatColor.RED + I18n.localize("invalidName", new Object[0]));
                    return true;
                }
            }
            System.out.println("target: " + this.target);
            System.out.println("targetUUID: " + this.targetUUID);
        }
        try {
            this.check();
            this.execute();
        }
        catch (CommandException ex) {
            Throwable error = ex;
            while (error instanceof Exception) {
                Util.message(sender, error.getMessage());
                error = error.getCause();
            }
        }
        return true;
    }

    private void init() {
        this.args.clear();
        this.player = null;
        this.isPlayer = false;
        this.senderName = "Console";
        this.target = "";
        this.targetUUID = "";
        this.targetIP = "";
    }

    public abstract void execute() throws CommandException;

    protected List<String> tabComplete(MCBans plugin, CommandSender sender, String cmd, String[] preArgs) {
        return null;
    }

    public abstract boolean permission(CommandSender var1);

    public void sendUsage() {
    }

    private void check() throws CommandException {
        if (this.banning && (this.targetUUID.isEmpty() ? !Util.checkVault((Player)this.sender, Bukkit.getOfflinePlayer((String)this.target)) : !Util.checkVault((Player)this.sender, Bukkit.getOfflinePlayer((UUID)UUID.fromString(this.targetUUID))))) {
            throw new CommandException(ChatColor.RED + I18n.localize("permissionDenied", new Object[0]));
        }
    }
}

