/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.callBacks;

import com.mcbans.plugin.ActionLog;
import com.mcbans.plugin.MCBans;
import com.mcbans.plugin.request.JsonHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ServerChoose
implements Runnable {
    private final MCBans plugin;
    private final ActionLog log;
    private final List<String> apiServers = new ArrayList<String>(4){
        {
            this.add("api.mcbans.com");
        }
    };

    public ServerChoose(MCBans plugin) {
        this.plugin = plugin;
        this.log = plugin.getLog();
    }

    @Override
    public void run() {
        this.plugin.apiServer = null;
        this.log.info("Connecting to the API server.");
        long d = 99999L;
        String fastest = null;
        for (String server : this.apiServers) {
            try {
                long pingTime = System.currentTimeMillis();
                JsonHandler webHandle = new JsonHandler(this.plugin);
                HashMap<String, String> items = new HashMap<String, String>();
                items.put("exec", "check");
                String urlReq = webHandle.urlparse(items);
                String jsonText = webHandle.request_from_api(urlReq, server);
                if (!jsonText.equals("up")) continue;
                long ft = System.currentTimeMillis() - pingTime;
                this.log.info("API Server found: " + server + " :: response time: " + ft);
                if (d <= ft) continue;
                d = ft;
                fastest = server;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NullPointerException nullPointerException) {}
        }
        if (fastest != null) {
            this.log.info("Fastest server selected: " + fastest + " :: response time: " + d);
        } else {
            this.log.warning("Cannot reach the MCBans API Server.");
            this.log.warning("Check your network connection or notify MCBans staff.");
        }
        this.plugin.apiServer = fastest;
    }
}

