/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.callBacks;

import com.mcbans.plugin.MCBans;
import com.mcbans.plugin.api.data.PlayerLookupData;
import com.mcbans.plugin.callBacks.BaseCallback;
import com.mcbans.plugin.util.Util;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class LookupCallback
extends BaseCallback {
    public LookupCallback(MCBans plugin, CommandSender sender) {
        super(plugin, sender);
    }

    public LookupCallback() {
        super(MCBans.getInstance(), null);
    }

    public void success(PlayerLookupData data) {
        if (data.getGlobals().size() > 0 || data.getLocals().size() > 0 || data.getOthers().size() > 0) {
            Util.message(this.sender, ChatColor.DARK_GRAY + "------------------------------");
        }
        Util.message(this.sender, ChatColor.GRAY + "Player " + ChatColor.RED + data.getPlayerName() + ChatColor.GRAY + " has " + ChatColor.RED + data.getTotal() + " ban(s)" + ChatColor.GRAY + " and " + ChatColor.BLUE + data.getReputation() + " REP" + ChatColor.GRAY + ".");
        if (data.getGlobals().size() > 0) {
            Util.message(this.sender, ChatColor.RED + "Global Bans:");
            for (String record : data.getGlobals()) {
                Util.message(this.sender, record);
            }
        }
        if (data.getLocals().size() > 0) {
            Util.message(this.sender, ChatColor.GOLD + "Local Bans:");
            for (String record : data.getLocals()) {
                Util.message(this.sender, record);
            }
        }
        if (data.getOthers().size() > 0) {
            for (String record : data.getOthers()) {
                Util.message(this.sender, record);
            }
        }
        if (data.getGlobals().size() > 0 || data.getLocals().size() > 0 || data.getOthers().size() > 0) {
            Util.message(this.sender, ChatColor.DARK_GRAY + "------------------------------");
        }
    }

    @Override
    public void success() {
        throw new IllegalArgumentException("Wrong Usage!");
    }

    @Override
    public void error(String error) {
        if (error != null && this.sender != null) {
            Util.message(this.sender, ChatColor.RED + error);
        }
    }
}

