/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.bukkitListeners;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mcbans.plugin.ActionLog;
import com.mcbans.plugin.ConfigurationManager;
import com.mcbans.plugin.I18n;
import com.mcbans.plugin.MCBans;
import com.mcbans.plugin.permission.Perms;
import com.mcbans.plugin.request.DisconnectRequest;
import com.mcbans.plugin.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class PlayerListener
implements Listener {
    private final MCBans plugin;
    private final ActionLog log;
    private final ConfigurationManager config;
    public static Cache<String, String> cache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();

    public PlayerListener(MCBans plugin) {
        this.plugin = plugin;
        this.log = plugin.getLog();
        this.config = plugin.getConfigs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onAsyncPlayerPreLoginEvent(AsyncPlayerPreLoginEvent event) {
        block22: {
            try {
                String response = (String)cache.getIfPresent((Object)event.getName().toLowerCase());
                if (response == null) {
                    int check = 1;
                    while (this.plugin.apiServer == null) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (++check <= 5) continue;
                        if (this.config.isFailsafe()) {
                            this.log.warning("Can't reach the MCBans API Server! Kicked player: " + event.getName());
                            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, I18n.localize("unavailable", new Object[0]));
                        } else {
                            this.log.warning("Can't reach the MCBans API Server! Check passed player: " + event.getName());
                        }
                        return;
                    }
                    String uriStr = "http://" + this.plugin.apiServer + "/v3/" + this.config.getApiKey() + "/login/" + URLEncoder.encode(event.getName(), "UTF-8") + "/" + URLEncoder.encode(event.getAddress().getHostAddress(), "UTF-8") + "/" + this.plugin.apiRequestSuffix;
                    URLConnection conn = new URL(uriStr).openConnection();
                    conn.setConnectTimeout(this.config.getTimeoutInSec() * 1000);
                    conn.setReadTimeout(this.config.getTimeoutInSec() * 500);
                    conn.setUseCaches(false);
                    response = null;
                    try (BufferedReader br = null;){
                        br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                        response = br.readLine();
                    }
                    if (response == null) {
                        if (this.config.isFailsafe()) {
                            this.log.warning("Null response! Kicked player: " + event.getName());
                            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, I18n.localize("unavailable", new Object[0]));
                        } else {
                            this.log.warning("Null response! Check passed player: " + event.getName());
                        }
                        return;
                    }
                    cache.put((Object)event.getName().toLowerCase(), (Object)response);
                } else {
                    this.plugin.debug("Retrieved from cache");
                }
                this.plugin.debug("Response: " + response);
                this.handleConnectionData(response, event);
            }
            catch (SocketTimeoutException ex) {
                this.log.warning("Cannot connect to the MCBans API server: timeout");
                if (this.config.isFailsafe()) {
                    event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, I18n.localize("unavailable", new Object[0]));
                }
            }
            catch (IOException ex) {
                this.log.warning("Cannot connect to the MCBans API server!");
                if (this.config.isDebug()) {
                    ex.printStackTrace();
                }
                if (this.config.isFailsafe()) {
                    event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, I18n.localize("unavailable", new Object[0]));
                }
            }
            catch (Exception ex) {
                this.log.warning("An error occurred in AsyncPlayerPreLoginEvent. Please report this!");
                ex.printStackTrace();
                if (!this.config.isFailsafe()) break block22;
                this.log.warning("Internal exception! Kicked player: " + event.getName());
                event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, I18n.localize("unavailable", new Object[0]));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!event.getPlayer().getServer().getOnlineMode()) {
            new Thread(new HandleConnectionData(event)).start();
        } else {
            final Player player = event.getPlayer();
            HashMap<String, String> pcache = this.plugin.playerCache.remove(player.getName());
            if (pcache == null) {
                return;
            }
            if (pcache.containsKey("b")) {
                Util.message((CommandSender)player, ChatColor.RED + I18n.localize("bansOnRecord", new Object[0]));
                Perms.VIEW_BANS.message(ChatColor.RED + I18n.localize("previousBans", "%PLAYER%", player.getName()));
                if (!Perms.HIDE_VIEW.has((Permissible)player)) {
                    String prev = pcache.get("b");
                    if (this.config.isSendDetailPrevBans() && prev != null) {
                        String[] bans;
                        prev = prev.trim();
                        String[] stringArray = bans = prev.split(",");
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String ban = stringArray[i];
                            String[] data = ban.split("\\$");
                            if (data.length != 3) continue;
                            Perms.VIEW_BANS.message(ChatColor.WHITE + data[1] + ChatColor.DARK_GRAY + " // " + ChatColor.WHITE + data[0] + ChatColor.GRAY + " (by " + data[2] + ")");
                        }
                    }
                }
            }
            if (pcache.containsKey("d")) {
                Util.message((CommandSender)player, ChatColor.RED + I18n.localize("disputes", "%COUNT%", pcache.get("d")));
            }
            if (pcache.containsKey("pn")) {
                StringBuilder plist = new StringBuilder();
                for (String name : pcache.get("pn").split(",")) {
                    plist.append(plist.length() == 0 ? "" : ", ").append(name);
                }
                Perms.VIEW_PREVIOUS.message(ChatColor.RED + I18n.localize("previousNames", "%PLAYER%", player.getName(), "%PLAYERS%", plist.toString()));
            }
            if (pcache.containsKey("dnsbl")) {
                StringBuilder proxlist = new StringBuilder();
                for (String name : pcache.get("dnsbl").split(",")) {
                    String from = name.split("$")[0];
                    String reason = name.split("$")[1];
                    proxlist.append(proxlist.length() == 0 ? "" : ", ").append("[ ").append(from).append(" { ").append(reason).append(" } ]");
                }
                Perms.VIEW_PROXY.message(ChatColor.RED + I18n.localize("proxyDetected", "%PLAYER%", player.getName(), "%REASON%", proxlist.toString()));
            }
            if (pcache.containsKey("a") && !Perms.HIDE_VIEW.has((Permissible)player)) {
                Perms.VIEW_ALTS.message(ChatColor.DARK_PURPLE + I18n.localize("altAccounts", "%PLAYER%", player.getName(), "%ALTS%", pcache.get("al")));
            }
            if (pcache.containsKey("m")) {
                Util.message((CommandSender)Bukkit.getConsoleSender(), ChatColor.AQUA + player.getName() + " is an MCBans staff member.");
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        Set<Player> players = Perms.VIEW_STAFF.getPlayers();
                        players.addAll(Perms.ADMIN.getPlayers());
                        players.addAll(Perms.BAN_GLOBAL.getPlayers());
                        for (Player p : players) {
                            if (!p.canSee(player)) continue;
                            Util.message((CommandSender)p, ChatColor.AQUA + I18n.localize("isMCBansMod", "%PLAYER%", player.getName()));
                        }
                    }
                }, 1L);
                HashSet<String> admins = new HashSet<String>();
                for (Player p : Perms.ADMIN.getPlayers()) {
                    admins.add(p.getName());
                }
                Util.message((CommandSender)player, ChatColor.AQUA + "You are an MCBans staff member. (ver " + this.plugin.getDescription().getVersion() + ")");
                Util.message((CommandSender)player, ChatColor.AQUA + "Online Admins: " + (admins.size() > 0 ? Util.join(admins, ", ") : ChatColor.GRAY + "(none)"));
                this.plugin.mcbStaff.add(player.getName());
            }
            if (this.config.isSendJoinMessage()) {
                Util.message((CommandSender)player, ChatColor.RED + "This server is secured by MCBans.");
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        new Thread(new DisconnectRequest(this.plugin, event.getPlayer().getName())).start();
        if (this.plugin.mcbStaff.contains(event.getPlayer().getName())) {
            this.plugin.mcbStaff.remove(event.getPlayer().getName());
        }
    }

    public void handleConnectionData(String response, AsyncPlayerPreLoginEvent event) {
        HashMap<String, String> tmp;
        String[] s = response.split(";");
        if (s.length >= 5) {
            if (s[0].equals("l") || s[0].equals("g") || s[0].equals("t") || s[0].equals("i") || s[0].equals("s")) {
                String[] reasonData = s[1].split("\\$");
                event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, I18n.localize("banReturnMessage", "%REASON%", reasonData[0], "%ADMIN%", reasonData[1], "%BANID%", reasonData[2], "%TYPE%", reasonData[3]));
                return;
            }
            if (this.config.getMinRep() > Double.valueOf(s[2])) {
                event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, I18n.localize("underMinRep", new Object[0]));
                return;
            }
            if (this.config.isEnableMaxAlts() && this.config.getMaxAlts() < Integer.valueOf(s[3]) && !Perms.EXEMPT_MAXALTS.has(event.getName())) {
                event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, I18n.localize("overMaxAlts", new Object[0]));
                return;
            }
            tmp = new HashMap<String, String>();
            if (s[0].equals("b") && s.length >= 8) {
                tmp.put("b", s[7]);
            }
            if (Integer.parseInt(s[3]) > 0 && s.length >= 7) {
                tmp.put("a", s[3]);
                tmp.put("al", s[6]);
            }
            if (s.length >= 5 && s[4].equals("y")) {
                tmp.put("m", "y");
            }
            if (s.length >= 6 && Integer.parseInt(s[5]) > 0) {
                tmp.put("d", s[5]);
            }
            if (s.length >= 9 && !s[8].equals("")) {
                tmp.put("pn", s[8]);
            }
            if (s.length >= 10 && !s[9].equals("")) {
                tmp.put("dnsbl", s[9]);
            }
            if (s.length == 8) {
                // empty if block
            }
        } else {
            if (response.toString().contains("Server Disabled")) {
                Util.message((CommandSender)Bukkit.getConsoleSender(), ChatColor.RED + "This server has been disabled by MCBans staff. Please go to forums.mcbans.com.");
                return;
            }
            if (this.config.isFailsafe()) {
                this.log.warning("Invalid response!(" + s.length + ") Kicked player: " + event.getName());
                event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_BANNED, I18n.localize("unavailable", new Object[0]));
            } else {
                this.log.warning("Invalid response!(" + s.length + ") Check passed player: " + event.getName());
            }
            this.log.warning("Response: " + response);
            return;
        }
        this.plugin.playerCache.put(event.getName(), tmp);
        this.plugin.debug(event.getName() + " authenticated with " + s[2] + " rep");
    }

    private class HandleConnectionData
    implements Runnable {
        private PlayerJoinEvent event = null;

        public HandleConnectionData(PlayerJoinEvent event) {
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String response = "";
            try {
                int check = 1;
                while (((PlayerListener)PlayerListener.this).plugin.apiServer == null) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (++check <= 5) continue;
                    if (PlayerListener.this.config.isFailsafe()) {
                        PlayerListener.this.log.warning("Can't reach the MCBans API Servers! Kicked player: " + this.event.getPlayer().getName());
                    } else {
                        PlayerListener.this.log.warning("Can't reach the MCBans API Servers! Check passed player: " + this.event.getPlayer().getName());
                    }
                    return;
                }
                String uriStr = "http://" + ((PlayerListener)PlayerListener.this).plugin.apiServer + "/v3/" + PlayerListener.this.config.getApiKey() + "/details/" + URLEncoder.encode(this.event.getPlayer().getName(), "UTF-8") + "/" + URLEncoder.encode(this.event.getPlayer().getAddress().getAddress().getHostAddress(), "UTF-8") + "/" + ((PlayerListener)PlayerListener.this).plugin.apiRequestSuffix;
                URLConnection conn = new URL(uriStr).openConnection();
                conn.setConnectTimeout(PlayerListener.this.config.getTimeoutInSec() * 1000);
                conn.setReadTimeout(PlayerListener.this.config.getTimeoutInSec() * 1000);
                conn.setUseCaches(false);
                try (BufferedReader br = null;){
                    br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    response = br.readLine();
                }
                PlayerListener.this.plugin.debug("Response: " + response);
            }
            catch (SocketTimeoutException ex) {
                PlayerListener.this.log.warning("Cannot connect to the MCBans API server: timeout");
            }
            catch (IOException ex) {
                PlayerListener.this.log.warning("Cannot connect to the MCBans API server!");
                if (PlayerListener.this.config.isDebug()) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                PlayerListener.this.log.warning("An error occurred in AsyncPlayerPreLoginEvent. Please report this to an MCBans developer.");
                ex.printStackTrace();
            }
            String[] s = response.split(";");
            if (s.length >= 6) {
                HashMap<String, String> pcache = new HashMap<String, String>();
                if (s[0].equals("b") && s.length >= 8) {
                    pcache.put("b", s[7]);
                }
                if (Integer.parseInt(s[3]) > 0 && s.length >= 7) {
                    pcache.put("a", s[3]);
                    pcache.put("al", s[6]);
                }
                if (s.length >= 5 && s[4].equals("y")) {
                    pcache.put("m", "y");
                }
                if (s.length >= 6 && Integer.parseInt(s[5]) > 0) {
                    pcache.put("d", s[5]);
                }
                if (s.length >= 9 && !s[8].equals("")) {
                    pcache.put("pn", s[8]);
                }
                if (s.length >= 10 && !s[9].equals("")) {
                    pcache.put("dnsbl", s[9]);
                }
                final Player player = this.event.getPlayer();
                if (pcache == null) {
                    return;
                }
                if (pcache.containsKey("b")) {
                    Util.message((CommandSender)player, ChatColor.RED + I18n.localize("bansOnRecord", new Object[0]));
                    Perms.VIEW_BANS.message(ChatColor.RED + I18n.localize("previousBans", "%PLAYER%", player.getName()));
                    if (!Perms.HIDE_VIEW.has((Permissible)player)) {
                        String prev = (String)pcache.get("b");
                        if (PlayerListener.this.config.isSendDetailPrevBans() && prev != null) {
                            String[] bans;
                            prev = prev.trim();
                            String[] stringArray = bans = prev.split(",");
                            int n = stringArray.length;
                            for (int i = 0; i < n; ++i) {
                                String ban = stringArray[i];
                                String[] data = ban.split("\\$");
                                if (data.length != 3) continue;
                                Perms.VIEW_BANS.message(ChatColor.WHITE + data[1] + ChatColor.DARK_GRAY + " // " + ChatColor.WHITE + data[0] + ChatColor.GRAY + " (by " + data[2] + ")");
                            }
                        }
                    }
                }
                if (pcache.containsKey("d")) {
                    Util.message((CommandSender)player, ChatColor.RED + I18n.localize("disputes", "%COUNT%", pcache.get("d")));
                }
                if (pcache.containsKey("pn")) {
                    StringBuilder plist = new StringBuilder();
                    for (String name : ((String)pcache.get("pn")).split(",")) {
                        plist.append(plist.length() == 0 ? "" : ", ").append(name);
                    }
                    Perms.VIEW_PREVIOUS.message(ChatColor.RED + I18n.localize("previousNames", "%PLAYER%", player.getName(), "%PLAYERS%", plist.toString()));
                }
                if (pcache.containsKey("dnsbl")) {
                    StringBuilder proxlist = new StringBuilder();
                    for (String name : ((String)pcache.get("dnsbl")).split(",")) {
                        String from = name.split("$")[0];
                        String reason = name.split("$")[1];
                        proxlist.append(proxlist.length() == 0 ? "" : ", ").append("[ ").append(from).append(" { ").append(reason).append(" } ]");
                    }
                    Perms.VIEW_PROXY.message(ChatColor.RED + I18n.localize("proxyDetected", "%PLAYER%", player.getName(), "%REASON%", proxlist.toString()));
                }
                if (pcache.containsKey("a") && !Perms.HIDE_VIEW.has((Permissible)player)) {
                    Perms.VIEW_ALTS.message(ChatColor.DARK_PURPLE + I18n.localize("altAccounts", "%PLAYER%", player.getName(), "%ALTS%", pcache.get("al")));
                }
                if (pcache.containsKey("m")) {
                    Util.message((CommandSender)Bukkit.getConsoleSender(), ChatColor.AQUA + player.getName() + " is an MCBans staff member.");
                    PlayerListener.this.plugin.getServer().getScheduler().runTaskLater((Plugin)PlayerListener.this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            Set<Player> players = Perms.VIEW_STAFF.getPlayers();
                            players.addAll(Perms.ADMIN.getPlayers());
                            players.addAll(Perms.BAN_GLOBAL.getPlayers());
                            for (Player p : players) {
                                if (!p.canSee(player)) continue;
                                Util.message((CommandSender)p, ChatColor.AQUA + I18n.localize("isMCBansMod", "%PLAYER%", player.getName()));
                            }
                        }
                    }, 1L);
                    HashSet<String> admins = new HashSet<String>();
                    for (Player p : Perms.ADMIN.getPlayers()) {
                        admins.add(p.getName());
                    }
                    Util.message((CommandSender)player, ChatColor.AQUA + "You are an MCBans staff member. (ver " + PlayerListener.this.plugin.getDescription().getVersion() + ")");
                    Util.message((CommandSender)player, ChatColor.AQUA + "Online Admins: " + (admins.size() > 0 ? Util.join(admins, ", ") : ChatColor.GRAY + "(none)"));
                    ((PlayerListener)PlayerListener.this).plugin.mcbStaff.add(player.getName());
                }
                if (PlayerListener.this.config.isSendJoinMessage()) {
                    Util.message((CommandSender)player, ChatColor.RED + "This server is secured by MCBans.");
                }
            } else {
                if (response.toString().contains("Server Disabled")) {
                    Util.message((CommandSender)Bukkit.getConsoleSender(), ChatColor.RED + "This server has been disabled by MCBans staff. Please go to forums.mcbans.com.");
                    return;
                }
                PlayerListener.this.log.warning("Response: " + response);
                return;
            }
        }
    }
}

