/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.api.data;

import com.mcbans.plugin.org.json.JSONException;
import com.mcbans.plugin.org.json.JSONObject;
import com.mcbans.plugin.util.Util;
import java.util.ArrayList;
import java.util.List;

public class PlayerLookupData {
    private String name;
    private int total = 0;
    private double reputation = 10.0;
    private List<String> global = new ArrayList<String>();
    private List<String> local = new ArrayList<String>();
    private List<String> other = new ArrayList<String>();

    public PlayerLookupData(String name, JSONObject response) throws JSONException, NullPointerException {
        int v;
        if (name == null || response == null) {
            return;
        }
        this.name = name;
        if (response.has("player")) {
            this.name = response.getString("player");
        }
        if (Util.isInteger(response.getString("total").trim())) {
            this.total = Integer.parseInt(response.getString("total").trim());
        }
        if (Util.isDouble(response.getString("reputation").trim())) {
            this.reputation = Double.parseDouble(response.getString("reputation").trim());
        }
        if (response.getJSONArray("global").length() > 0) {
            for (v = 0; v < response.getJSONArray("global").length(); ++v) {
                this.global.add(response.getJSONArray("global").getString(v));
            }
        }
        if (response.getJSONArray("local").length() > 0) {
            for (v = 0; v < response.getJSONArray("local").length(); ++v) {
                this.local.add(response.getJSONArray("local").getString(v));
            }
        }
        if (response.getJSONArray("other").length() > 0) {
            for (v = 0; v < response.getJSONArray("other").length(); ++v) {
                this.other.add(response.getJSONArray("other").getString(v));
            }
        }
    }

    public String getPlayerName() {
        return this.name;
    }

    public int getTotal() {
        return this.total;
    }

    public double getReputation() {
        return this.reputation;
    }

    public List<String> getGlobals() {
        return this.global;
    }

    public List<String> getLocals() {
        return this.local;
    }

    public List<String> getOthers() {
        return this.other;
    }
}

