/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.api;

import com.mcbans.plugin.BanType;
import com.mcbans.plugin.MCBans;
import com.mcbans.plugin.callBacks.AltLookupCallback;
import com.mcbans.plugin.callBacks.BanLookupCallback;
import com.mcbans.plugin.callBacks.LookupCallback;
import com.mcbans.plugin.callBacks.MessageCallback;
import com.mcbans.plugin.request.AltLookupRequest;
import com.mcbans.plugin.request.Ban;
import com.mcbans.plugin.request.BanIpRequest;
import com.mcbans.plugin.request.BanLookupRequest;
import com.mcbans.plugin.request.Kick;
import com.mcbans.plugin.request.LookupRequest;
import com.mcbans.plugin.util.Util;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MCBansAPI {
    private final MCBans plugin;
    private final String pname;
    private static HashMap<Plugin, MCBansAPI> apiHandles = new HashMap();

    private MCBansAPI(MCBans plugin, String pname) {
        plugin.getLog().info("MCBans API linked with: " + pname);
        this.plugin = plugin;
        this.pname = pname;
    }

    private void ban(BanType type, String targetName, String targetUUID, String senderName, String senderUUID, String reason, String duration, String measure) {
        if (targetName == null || senderName == null) {
            return;
        }
        String targetIP = "";
        if (type != BanType.UNBAN) {
            Player target = Bukkit.getPlayerExact((String)targetName);
            targetIP = target != null ? target.getAddress().getAddress().getHostAddress() : "";
        }
        Ban banControl = new Ban(this.plugin, type.getActionName(), targetName, targetUUID, targetIP, senderName, senderUUID, reason, duration, measure, null, false);
        banControl.run();
    }

    public void localBan(String targetName, String targetUUID, String senderName, String senderUUID, String reason) {
        this.plugin.getLog().info("Plugin " + this.pname + " tried to local ban player " + targetName);
        reason = reason == null || reason == "" ? this.plugin.getConfigs().getDefaultLocal() : reason;
        this.ban(BanType.LOCAL, targetName, targetUUID, senderName, senderUUID, reason, "", "");
    }

    public void globalBan(String targetName, String targetUUID, String senderName, String senderUUID, String reason) {
        this.plugin.getLog().info("Plugin " + this.pname + " tried to global ban player " + targetName);
        if (reason == null || reason == "") {
            return;
        }
        this.ban(BanType.GLOBAL, targetName, targetUUID, senderName, senderUUID, reason, "", "");
    }

    public void tempBan(String targetName, String targetUUID, String senderName, String senderUUID, String reason, String duration, String measure) {
        this.plugin.getLog().info("Plugin " + this.pname + " tried to temp ban player " + targetName);
        reason = reason == null || reason == "" ? this.plugin.getConfigs().getDefaultTemp() : reason;
        duration = duration == null ? "" : duration;
        measure = measure == null ? "" : measure;
        this.ban(BanType.TEMP, targetName, targetUUID, senderName, senderUUID, reason, duration, measure);
    }

    public void unBan(String targetName, String targetUUID, String senderName, String senderUUID) {
        this.plugin.getLog().info("Plugin " + this.pname + " tried to unban player " + targetName);
        if (targetName == null || senderName == null) {
            this.plugin.getLog().info("Invalid usage (null): unBan");
            return;
        }
        if (!Util.isValidName(targetName) && !Util.isValidIP(targetName)) {
            this.plugin.getLog().info("The target you are trying to unban is not a valid name or IP format!");
            return;
        }
        this.ban(BanType.UNBAN, targetName, targetUUID, senderName, senderUUID, "", "", "");
    }

    public void ipBan(String ip, String senderName, String senderUUID, String reason, MessageCallback callback) {
        this.plugin.getLog().info("Plugin " + this.pname + " tried to ip ban " + ip);
        if (ip == null || senderName == null || callback == null) {
            this.plugin.getLog().info("Invalid usage (null): ipBan");
            return;
        }
        if (!Util.isValidIP(ip)) {
            this.plugin.getLog().info("Invalid IP address (" + ip + "): ipBan");
            return;
        }
        if (reason == null || reason.length() <= 0) {
            reason = this.plugin.getConfigs().getDefaultLocal();
        }
        BanIpRequest request = new BanIpRequest(this.plugin, callback, ip, reason, senderName, senderUUID);
        Thread thread = new Thread(request);
        thread.start();
    }

    public void ipBan(String ip, String senderName, String reason) {
        this.ipBan(ip, senderName, "", reason, new MessageCallback(this.plugin));
    }

    public void kick(String targetName, String targetUUID, String senderName, String senderUUID, String reason) {
        reason = reason == null || reason == "" ? this.plugin.getConfigs().getDefaultKick() : reason;
        Kick kickPlayer = new Kick(this.plugin, targetName, targetUUID, senderName, senderUUID, reason, true);
        kickPlayer.run();
    }

    public void lookupPlayer(String targetName, String targetUUID, String senderName, String senderUUID, LookupCallback callback) {
        this.plugin.getLog().info("Plugin " + this.pname + " tried to lookup player " + targetName);
        if (targetName == null || callback == null) {
            this.plugin.getLog().info("Invalid usage (null): lookupPlayer");
            return;
        }
        if (!Util.isValidName(targetName)) {
            callback.error("Invalid lookup target name.");
        }
        LookupRequest request = new LookupRequest(this.plugin, callback, targetName, targetUUID, senderName, senderUUID);
        Thread triggerThread = new Thread(request);
        triggerThread.start();
    }

    public void lookupBan(int banID, BanLookupCallback callback) {
        this.plugin.getLog().info("Plugin " + this.pname + " tried to ban lookup " + banID);
        if (banID < 0 || callback == null) {
            this.plugin.getLog().info("Invalid usage (null): lookupBan");
            return;
        }
        BanLookupRequest request = new BanLookupRequest(this.plugin, callback, banID);
        Thread triggerThread = new Thread(request);
        triggerThread.start();
    }

    public void lookupAlt(String playerName, AltLookupCallback callback) {
        this.plugin.getLog().info("Plugin " + this.pname + " tried to alt lookup " + playerName);
        if (playerName == null || callback == null) {
            this.plugin.getLog().info("Invalid usage (null): lookupAlt");
            return;
        }
        if (!Util.isValidName(playerName)) {
            callback.error("Invalid alternate account lookup target name.");
        }
        AltLookupRequest request = new AltLookupRequest(this.plugin, callback, playerName);
        Thread triggerThread = new Thread(request);
        triggerThread.start();
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public static MCBansAPI getHandle(MCBans plugin, Plugin otherPlugin) {
        if (otherPlugin == null) {
            return null;
        }
        MCBansAPI api = apiHandles.get(otherPlugin);
        if (api == null) {
            api = new MCBansAPI(plugin, otherPlugin.getName());
            apiHandles.put(otherPlugin, api);
        }
        return api;
    }
}

