/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin;

import com.mcbans.plugin.ActionLog;
import com.mcbans.plugin.util.FileStructure;
import com.mcbans.plugin.util.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;

public class I18n {
    private static final String languageDirName = "languages";
    private static Configuration fallbackMessages;
    private static Configuration messages;
    public static final String PLAYER = "%PLAYER%";
    public static final String SENDER = "%ADMIN%";
    public static final String REASON = "%REASON%";
    public static final String BANID = "%BANID%";
    public static final String ADMIN = "%ADMIN%";
    public static final String TYPE = "%TYPE%";
    public static final String PLAYERS = "%PLAYERS%";
    public static final String BADWORD = "%BADWORD%";
    public static final String ALTS = "%ALTS%";
    public static final String COUNT = "%COUNT%";
    public static final String IP = "%IP%";

    public static void init(String locale) {
        I18n.extractLanguageFiles(false);
        try {
            fallbackMessages = I18n.loadLanguageFile("default");
        }
        catch (Exception ex) {
            ActionLog.getInstance().warning("MCBans could not load default (default.yml) messages file!");
        }
        try {
            I18n.setCurrentLanguage(locale);
        }
        catch (Exception ex) {
            ActionLog.getInstance().warning("MCBans could not load messages for " + locale + ": using default.yml");
            messages = fallbackMessages;
        }
    }

    public static void extractLanguageFiles(boolean force) {
        File langDir = I18n.getLanguagesDir();
        FileStructure.createDir(langDir);
        ArrayList<String> locales = new ArrayList<String>();
        locales.add("default");
        locales.add("dutch");
        locales.add("french");
        locales.add("german");
        locales.add("ja-jp");
        locales.add("norwegian");
        locales.add("portuguese");
        locales.add("spanish");
        locales.add("sv-se");
        for (String locale : locales) {
            FileStructure.extractResource("/languages/" + locale + ".yml", langDir, force, true);
        }
    }

    public static void setCurrentLanguage(String locale) throws Exception {
        messages = I18n.loadLanguageFile(locale);
    }

    private static Configuration loadLanguageFile(String locale) throws Exception {
        File langDir = I18n.getLanguagesDir();
        File file = new File(langDir, locale + ".yml");
        if (file == null || !file.isFile() || !file.canRead()) {
            ActionLog.getInstance().warning("Unknown language file: " + locale);
            return null;
        }
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)file);
        if (fallbackMessages != null && conf.getKeys(true).size() != fallbackMessages.getKeys(true).size()) {
            for (String key : fallbackMessages.getKeys(true)) {
                if (conf.contains(key) || fallbackMessages.isConfigurationSection(key)) continue;
                conf.set(key, fallbackMessages.get(key));
                ActionLog.getInstance().warning("Missing message key on " + locale + ".yml: " + key);
            }
        }
        return conf;
    }

    public static String localize(String key, Object ... args) {
        if (messages == null) {
            ActionLog.getInstance().warning("Localized messages file is NOT loaded.");
            return "!" + key + "!";
        }
        String msg = I18n.getString(messages, key);
        if (msg == null || msg.length() == 0) {
            if (msg == null) {
                ActionLog.getInstance().warning("Missing message key '" + key + "'");
            }
            if ((msg = I18n.getString(fallbackMessages, key)) == null || msg.length() == 0) {
                ActionLog.getInstance().warning("Please delete language files and type '/mcbans reload' to regenerate them.");
                return "!" + key + "!";
            }
        }
        msg = Util.color(msg);
        msg = msg.replace("\\n", "\n");
        Map<String, Object> binds = I18n.buildBinds(args);
        for (String bindKey : binds.keySet()) {
            if (bindKey == null) continue;
            Object obj = binds.get(bindKey);
            msg = msg.replace(bindKey, obj != null ? obj.toString() : "");
        }
        return msg;
    }

    private static Map<String, Object> buildBinds(Object ... args) {
        HashMap<String, Object> bind = new HashMap<String, Object>(args.length / 2);
        if (args == null || args.length < 2) {
            return bind;
        }
        for (int i = 0; i < args.length && i + 2 <= args.length; i += 2) {
            bind.put(args[i].toString(), args[i + 1]);
        }
        return bind;
    }

    private static String getString(Configuration conf, String key) {
        String s = null;
        Object o = conf.get(key);
        if (o instanceof String) {
            s = o.toString();
        } else if (o instanceof List) {
            List l = (List)o;
            s = Util.join(l, "\n");
        }
        return s;
    }

    private static File getLanguagesDir() {
        return new File(FileStructure.getPluginDir(), languageDirName);
    }
}

