/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin;

import com.mcbans.plugin.ActionLog;
import com.mcbans.plugin.MCBans;
import com.mcbans.plugin.util.FileStructure;
import com.mcbans.plugin.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigurationManager {
    private final int latestVersion = 2;
    private final MCBans plugin;
    private final ActionLog log;
    private FileConfiguration conf;
    private File pluginDir;
    private boolean isValidKey = false;

    public ConfigurationManager(MCBans plugin) {
        this.plugin = plugin;
        this.log = plugin.getLog();
        this.pluginDir = this.plugin.getDataFolder();
    }

    public void loadConfig(boolean initialLoad) throws Exception {
        FileStructure.createDir(this.pluginDir);
        File file = new File(this.pluginDir, "config.yml");
        if (!file.exists()) {
            FileStructure.extractResource("/config.yml", this.pluginDir, false, false);
            this.log.log(Level.INFO, "config.yml has not been found! We created a default config.yml for you!", false);
        }
        this.plugin.reloadConfig();
        this.conf = this.plugin.getConfig();
        this.checkver(this.conf.getInt("ConfigVersion", 1));
        if (this.conf.getString("apiKey", "").trim().length() != 40) {
            this.isValidKey = false;
            if (initialLoad) {
                Util.message((CommandSender)null, ChatColor.RED + "=== Missing OR Invalid API Key! ===");
                this.log.severe("MCBans detected a missing or invalid API Key!");
                this.log.severe("Please copy your API key to the configuration file.");
                this.log.severe("Don't have an API key? Go to: http://my.mcbans.com/servers/");
            } else {
                this.log.severe("MCBans detected a missing or invalid API Key! Please check config.yml!");
            }
        } else {
            this.isValidKey = true;
        }
        if (this.isEnableLog() && !new File(this.getLogFile()).exists()) {
            try {
                new File(this.getLogFile()).createNewFile();
            }
            catch (IOException ex) {
                this.log.warning("Could not create log file! " + this.getLogFile());
            }
        }
        if (!initialLoad && this.isEnableAutoSync()) {
            this.plugin.bansync.goRequest();
        }
    }

    private void checkver(int ver) {
        if (ver < 2) {
            String destName = "oldconfig-v" + ver + ".yml";
            String srcPath = new File(this.pluginDir, "config.yml").getPath();
            String destPath = new File(this.pluginDir, destName).getPath();
            try {
                FileStructure.copyTransfer(srcPath, destPath);
                this.log.info("Outdated config file! Automatically copied old config.yml to " + destName + "!");
            }
            catch (Exception ex) {
                this.log.warning("Failed to copy old config.yml!");
            }
            FileStructure.extractResource("/config.yml", this.pluginDir, true, false);
            this.plugin.reloadConfig();
            this.conf = this.plugin.getConfig();
            this.log.info("Deleted existing configuration file and generate a new one!");
        }
    }

    public boolean isValidApiKey() {
        return this.isValidKey;
    }

    public String getPrefix() {
        return Util.color(this.conf.getString("prefix", "[MCBans]"));
    }

    public String getApiKey() {
        if (!this.isValidKey) {
            Util.message((CommandSender)null, ChatColor.RED + "Invalid API Key! Edit your config.yml and type /mcbans reload");
            return "";
        }
        return this.conf.getString("apiKey", "").trim();
    }

    public String getLanguage() {
        return this.conf.getString("language", "default");
    }

    public String getPermission() {
        return this.conf.getString("permission", "SuperPerms");
    }

    public String getDefaultLocal() {
        return this.conf.getString("defaultLocal", "You have been banned!");
    }

    public String getDefaultTemp() {
        return this.conf.getString("defaultTemp", "You have been temporarily banned!");
    }

    public String getDefaultKick() {
        return this.conf.getString("defaultKick", "You have been kicked!");
    }

    public boolean isDebug() {
        return this.conf.getBoolean("isDebug", false);
    }

    public boolean isEnableLog() {
        return this.conf.getBoolean("logEnable", false);
    }

    public String getLogFile() {
        return this.conf.getString("logFile", "plugins/MCBans/actions.log");
    }

    public boolean isEnableMaxAlts() {
        return this.conf.getBoolean("enableMaxAlts", false);
    }

    public int getMaxAlts() {
        return this.conf.getInt("maxAlts", 2);
    }

    public String getAffectedWorlds() {
        return this.conf.getString("affectedWorlds", "*");
    }

    public int getBackDaysAgo() {
        return this.conf.getInt("backDaysAgo", 20);
    }

    public boolean isEnableAutoSync() {
        return this.conf.getBoolean("enableAutoSync", true);
    }

    public int getSyncInterval() {
        return this.conf.getInt("autoSyncInterval", 5);
    }

    public boolean isSendJoinMessage() {
        return this.conf.getBoolean("onJoinMCBansMessage", false);
    }

    public boolean isSendDetailPrevBans() {
        return this.conf.getBoolean("sendDetailPrevBansOnJoin", false);
    }

    public double getMinRep() {
        return this.conf.getDouble("minRep", 3.0);
    }

    public int getCallBackInterval() {
        return this.conf.getInt("callBackInterval", 15);
    }

    public int getTimeoutInSec() {
        return this.conf.getInt("timeout", 10);
    }

    public boolean isFailsafe() {
        return this.conf.getBoolean("failsafe", false);
    }
}

