/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin;

import com.mcbans.plugin.MCBans;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActionLog {
    private final Logger logger = Logger.getLogger("Minecraft");
    private final String logPrefix = "[MCBans] ";
    private final MCBans plugin;
    private static ActionLog instance;

    public ActionLog(MCBans plugin) {
        instance = this;
        this.plugin = plugin;
    }

    public void log(Level level, String message, boolean logToFile) {
        this.logger.log(level, "[MCBans] " + message);
        if (logToFile && this.plugin.getConfigs() != null && this.plugin.getConfigs().isEnableLog()) {
            this.writeLog(message);
        }
    }

    public void log(Level level, String message) {
        this.log(level, message, true);
    }

    public void fine(String message) {
        this.log(Level.FINE, message);
    }

    public void info(String message) {
        this.log(Level.INFO, message);
    }

    public void warning(String message) {
        this.log(Level.WARNING, message);
    }

    public void severe(String message) {
        this.log(Level.SEVERE, message);
    }

    private void writeLog(String message) {
        try {
            this.appendLine(this.plugin.getConfigs().getLogFile(), "[" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "] " + message);
        }
        catch (IOException ex) {
            this.logger.warning("[MCBans] Could not write log file! " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendLine(String file, String line) throws IOException {
        try (PrintWriter outputStream = null;){
            outputStream = new PrintWriter(new FileWriter(file, true));
            outputStream.println(line);
        }
    }

    public static ActionLog getInstance() {
        return instance;
    }
}

