/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.http.spi.request;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Supplier;

public class RequestBody {
    private final Supplier<InputStream> contentStreamProvider;
    private final long contentLength;

    private RequestBody(Supplier<InputStream> contentStreamProvider, long contentLength) {
        this.contentStreamProvider = contentStreamProvider;
        this.contentLength = contentLength;
    }

    public Supplier<InputStream> getContentStreamProvider() {
        return this.contentStreamProvider;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public static RequestBody fromPath(Path path) {
        try {
            return new RequestBody(() -> {
                try {
                    return Files.newInputStream(path, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }, Files.size(path));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static RequestBody fromFile(File file) {
        return RequestBody.fromPath(file.toPath());
    }

    public static RequestBody fromInputStream(Supplier<InputStream> contentStreamProvider, long contentLength) {
        return new RequestBody(contentStreamProvider, contentLength);
    }

    public static RequestBody fromBytes(byte[] bytes) {
        return new RequestBody(() -> new ByteArrayInputStream(bytes), bytes.length);
    }

    public static RequestBody fromString(String contents, Charset charset) {
        return RequestBody.fromBytes(contents.getBytes(charset));
    }

    public static RequestBody fromString(String contents) {
        return RequestBody.fromString(contents, StandardCharsets.UTF_8);
    }

    public static RequestBody empty() {
        return RequestBody.fromBytes(new byte[0]);
    }
}

