/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit.helper.v117;

import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.BlockRotatable;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Material;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.craftbukkit.v1_17_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.dynmap.DynmapChunk;
import org.dynmap.Log;
import org.dynmap.bukkit.helper.BukkitMaterial;
import org.dynmap.bukkit.helper.BukkitVersionHelper;
import org.dynmap.bukkit.helper.BukkitVersionHelperGeneric;
import org.dynmap.bukkit.helper.BukkitWorld;
import org.dynmap.bukkit.helper.v117.MapChunkCache117;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.Polygon;

public class BukkitVersionHelperSpigot117
extends BukkitVersionHelper {
    private final boolean unsafeAsync;
    private IRegistry<BiomeBase> reg = null;
    private Object[] biomelist;
    public static IdentityHashMap<IBlockData, DynmapBlockState> dataToState;
    private String[] biomenames;
    private static final Gson gson;

    public BukkitVersionHelperSpigot117() {
        this.unsafeAsync = true;
    }

    @Override
    public boolean isUnsafeAsync() {
        return this.unsafeAsync;
    }

    @Override
    public String[] getBlockNames() {
        int cnt = Block.p.a();
        String[] names = new String[cnt];
        for (int i = 0; i < cnt; ++i) {
            IBlockData bd = Block.getByCombinedId((int)i);
            names[i] = IRegistry.W.getKey((Object)bd.getBlock()).toString();
            Log.info(i + ": blk=" + names[i] + ", bd=" + bd.toString());
        }
        return names;
    }

    private IRegistry<BiomeBase> getBiomeReg() {
        if (this.reg == null) {
            this.reg = MinecraftServer.getServer().getCustomRegistry().b(IRegistry.aO);
        }
        return this.reg;
    }

    @Override
    public Object[] getBiomeBaseList() {
        if (this.biomelist == null) {
            this.biomelist = new Object[1024];
            for (int i = 0; i < 1024; ++i) {
                this.biomelist[i] = this.getBiomeReg().fromId(i);
            }
        }
        return this.biomelist;
    }

    @Override
    public int getBiomeBaseID(Object bb) {
        return this.getBiomeReg().getId((Object)((BiomeBase)bb));
    }

    @Override
    public void initializeBlockStates() {
        dataToState = new IdentityHashMap();
        HashMap<String, DynmapBlockState> lastBlockState = new HashMap<String, DynmapBlockState>();
        int cnt = Block.p.a();
        DynmapBlockState.Builder bld = new DynmapBlockState.Builder();
        for (int i = 0; i < cnt; ++i) {
            IBlockData bd = Block.getByCombinedId((int)i);
            Block b = bd.getBlock();
            String bname = IRegistry.W.getKey((Object)bd.getBlock()).toString();
            DynmapBlockState lastbs = (DynmapBlockState)lastBlockState.get(bname);
            int idx = 0;
            if (lastbs != null) {
                idx = lastbs.getStateCount();
            }
            String sb = "";
            String fname = bd.toString();
            int off1 = fname.indexOf(91);
            if (off1 >= 0) {
                int off2 = fname.indexOf(93);
                sb = fname.substring(off1 + 1, off2);
            }
            Material mat = bd.getMaterial();
            int lightAtten = b.g(bd, (IBlockAccess)BlockAccessAir.a, BlockPosition.b);
            bld.setBaseState(lastbs).setStateIndex(idx).setBlockName(bname).setStateName(sb).setMaterial(mat.toString()).setAttenuatesLight(lightAtten);
            if (mat.isSolid()) {
                bld.setSolid();
            }
            if (mat == Material.a) {
                bld.setAir();
            }
            if (bd.getBlock() instanceof BlockRotatable && bd.getMaterial() == Material.z) {
                bld.setLog();
            }
            if (mat == Material.E) {
                bld.setLeaves();
            }
            if (!bd.getFluid().isEmpty() && !(bd.getBlock() instanceof BlockFluids)) {
                bld.setWaterlogged();
            }
            DynmapBlockState dbs = bld.build();
            dataToState.put(bd, dbs);
            lastBlockState.put(bname, lastbs == null ? dbs : lastbs);
            Log.verboseinfo("blk=" + bname + ", idx=" + idx + ", state=" + sb + ", waterlogged=" + dbs.isWaterlogged());
        }
    }

    @Override
    public MapChunkCache getChunkCache(BukkitWorld dw, List<DynmapChunk> chunks) {
        MapChunkCache117 c = new MapChunkCache117(gencache);
        c.setChunks(dw, chunks);
        return c;
    }

    @Override
    public int getBiomeBaseWaterMult(Object bb) {
        BiomeBase biome = (BiomeBase)bb;
        return biome.l().b();
    }

    @Override
    public float getBiomeBaseTemperature(Object bb) {
        return ((BiomeBase)bb).k();
    }

    @Override
    public float getBiomeBaseHumidity(Object bb) {
        return ((BiomeBase)bb).getHumidity();
    }

    @Override
    public Polygon getWorldBorder(World world) {
        Polygon p = null;
        WorldBorder wb = world.getWorldBorder();
        if (wb != null) {
            Location c = wb.getCenter();
            double size = wb.getSize();
            if (size > 1.0 && size < 1.0E7) {
                p = new Polygon();
                p.addVertex(c.getX() - (size /= 2.0), c.getZ() - size);
                p.addVertex(c.getX() + size, c.getZ() - size);
                p.addVertex(c.getX() + size, c.getZ() + size);
                p.addVertex(c.getX() - size, c.getZ() + size);
            }
        }
        return p;
    }

    @Override
    public void sendTitleText(Player p, String title, String subtitle, int fadeInTicks, int stayTicks, int fadeOutTIcks) {
        if (p != null) {
            p.sendTitle(title, subtitle, fadeInTicks, stayTicks, fadeOutTIcks);
        }
    }

    @Override
    public BukkitMaterial[] getMaterialList() {
        return new BukkitMaterial[4096];
    }

    @Override
    public void unloadChunkNoSave(World w, Chunk c, int cx, int cz) {
        Log.severe("unloadChunkNoSave not implemented");
    }

    @Override
    public String[] getBiomeNames() {
        if (this.biomenames == null) {
            this.biomenames = new String[1024];
            for (int i = 0; i < 1024; ++i) {
                BiomeBase bb = (BiomeBase)this.getBiomeReg().fromId(i);
                if (bb == null) continue;
                this.biomenames[i] = bb.toString();
            }
        }
        return this.biomenames;
    }

    @Override
    public String getStateStringByCombinedId(int blkid, int meta) {
        Log.severe("getStateStringByCombinedId not implemented");
        return null;
    }

    @Override
    public String getBiomeBaseIDString(Object bb) {
        String s = ((BiomeBase)bb).toString();
        if (s != null) {
            String[] ss = s.split("\\.");
            return ss[ss.length - 1];
        }
        return null;
    }

    @Override
    public Object getUnloadQueue(World world) {
        Log.warning("getUnloadQueue not implemented yet");
        return null;
    }

    @Override
    public boolean isInUnloadQueue(Object unloadqueue, int x, int z) {
        Log.warning("isInUnloadQueue not implemented yet");
        return false;
    }

    @Override
    public Object[] getBiomeBaseFromSnapshot(ChunkSnapshot css) {
        Log.warning("getBiomeBaseFromSnapshot not implemented yet");
        return new Object[256];
    }

    @Override
    public long getInhabitedTicks(Chunk c) {
        return ((CraftChunk)c).getHandle().getInhabitedTime();
    }

    @Override
    public Map<?, ?> getTileEntitiesForChunk(Chunk c) {
        return ((CraftChunk)c).getHandle().l;
    }

    @Override
    public int getTileEntityX(Object te) {
        TileEntity tileent = (TileEntity)te;
        return tileent.getPosition().getX();
    }

    @Override
    public int getTileEntityY(Object te) {
        TileEntity tileent = (TileEntity)te;
        return tileent.getPosition().getY();
    }

    @Override
    public int getTileEntityZ(Object te) {
        TileEntity tileent = (TileEntity)te;
        return tileent.getPosition().getZ();
    }

    @Override
    public Object readTileEntityNBT(Object te, World w) {
        TileEntity tileent = (TileEntity)te;
        NBTTagCompound nbt = new NBTTagCompound();
        tileent.save(nbt);
        return nbt;
    }

    @Override
    public Object getFieldValue(Object nbt, String field) {
        NBTTagCompound rec = (NBTTagCompound)nbt;
        NBTBase val = rec.get(field);
        if (val == null) {
            return null;
        }
        if (val instanceof NBTTagByte) {
            return ((NBTTagByte)val).asByte();
        }
        if (val instanceof NBTTagShort) {
            return ((NBTTagShort)val).asShort();
        }
        if (val instanceof NBTTagInt) {
            return ((NBTTagInt)val).asInt();
        }
        if (val instanceof NBTTagLong) {
            return ((NBTTagLong)val).asLong();
        }
        if (val instanceof NBTTagFloat) {
            return Float.valueOf(((NBTTagFloat)val).asFloat());
        }
        if (val instanceof NBTTagDouble) {
            return ((NBTTagDouble)val).asDouble();
        }
        if (val instanceof NBTTagByteArray) {
            return ((NBTTagByteArray)val).getBytes();
        }
        if (val instanceof NBTTagString) {
            return ((NBTTagString)val).asString();
        }
        if (val instanceof NBTTagIntArray) {
            return ((NBTTagIntArray)val).getInts();
        }
        return null;
    }

    @Override
    public Player[] getOnlinePlayers() {
        Collection p = Bukkit.getServer().getOnlinePlayers();
        return p.toArray(new Player[0]);
    }

    @Override
    public double getHealth(Player p) {
        return p.getHealth();
    }

    @Override
    public String getSkinURL(Player player) {
        PropertyMap pm;
        String url = null;
        CraftPlayer cp = (CraftPlayer)player;
        GameProfile profile = cp.getProfile();
        if (profile != null && (pm = profile.getProperties()) != null) {
            String val;
            Collection txt = pm.get((Object)"textures");
            Property textureProperty = (Property)Iterables.getFirst((Iterable)pm.get((Object)"textures"), null);
            if (textureProperty != null && (val = textureProperty.getValue()) != null) {
                BukkitVersionHelperGeneric.TexturesPayload result = null;
                try {
                    String json = new String(Base64.getDecoder().decode(val), StandardCharsets.UTF_8);
                    result = (BukkitVersionHelperGeneric.TexturesPayload)gson.fromJson(json, BukkitVersionHelperGeneric.TexturesPayload.class);
                }
                catch (JsonParseException json) {
                }
                catch (IllegalArgumentException x) {
                    Log.warning("Malformed response from skin URL check: " + val);
                }
                if (result != null && result.textures != null && result.textures.containsKey("SKIN")) {
                    url = result.textures.get((Object)"SKIN").url;
                }
            }
        }
        return url;
    }

    @Override
    public int getWorldMinY(World w) {
        CraftWorld cw = (CraftWorld)w;
        return cw.getMinHeight();
    }

    @Override
    public boolean useGenericCache() {
        return true;
    }

    static {
        gson = new GsonBuilder().create();
    }
}

