/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit.helper;

import com.google.common.collect.ForwardingMultimap;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.dynmap.Log;
import org.dynmap.bukkit.helper.BukkitVersionHelper;

public abstract class BukkitVersionHelperGeneric
extends BukkitVersionHelper {
    private String obc_package = Bukkit.getServer().getClass().getPackage().getName();
    protected String nms_package = this.getNMSPackage();
    private boolean failed = false;
    protected static final Object[] nullargs = new Object[0];
    protected static final Class<?>[] nulltypes = new Class[0];
    private static final Map<?, ?> nullmap = Collections.emptyMap();
    protected Class<?> craftchunksnapshot;
    private Field ccss_biome;
    private Class<?> craftchunk;
    private Method cc_gethandle;
    private Class<?> craftworld;
    private Method cw_gethandle;
    protected Class<?> biomestorage;
    protected Field biomestoragebase;
    protected Class<?> biomebase;
    protected Class<?> biomebasearray;
    protected Field biomebaselist;
    protected Field biomebasetemp;
    protected Field biomebasehumi;
    protected Method biomebasetempfunc;
    protected Method biomebasehumifunc;
    protected Field biomebaseidstring;
    protected Field biomebaseid;
    protected Class<?> nmsworld;
    protected Class<?> chunkprovserver;
    protected Class<?> longhashset;
    protected Field nmsw_chunkproviderserver;
    protected Field cps_unloadqueue;
    protected boolean cps_unloadqueue_isSet;
    protected Method lhs_containskey;
    protected Class<?> nmschunk;
    protected Field nmsc_tileentities;
    protected Field nmsc_inhabitedticks;
    protected Class<?> nbttagcompound;
    protected Class<?> nbttagbyte;
    protected Class<?> nbttagshort;
    protected Class<?> nbttagint;
    protected Class<?> nbttaglong;
    protected Class<?> nbttagfloat;
    protected Class<?> nbttagdouble;
    protected Class<?> nbttagbytearray;
    protected Class<?> nbttagstring;
    protected Class<?> nbttagintarray;
    protected Method compound_get;
    protected Field nbttagbyte_val;
    protected Field nbttagshort_val;
    protected Field nbttagint_val;
    protected Field nbttaglong_val;
    protected Field nbttagfloat_val;
    protected Field nbttagdouble_val;
    protected Field nbttagbytearray_val;
    protected Field nbttagstring_val;
    protected Field nbttagintarray_val;
    protected Class<?> nms_tileentity;
    protected Method nmst_readnbt;
    protected Field nmst_x;
    protected Field nmst_y;
    protected Field nmst_z;
    protected Method nmst_getposition;
    protected Class<?> nms_blockposition;
    protected Method nmsbp_getx;
    protected Method nmsbp_gety;
    protected Method nmsbp_getz;
    protected Method server_getonlineplayers;
    protected Method player_gethealth;
    private Class<?> obc_craftplayer;
    private Method obcplayer_getprofile;
    private Class<?> cma_gameprofile;
    private Method cmaprofile_getproperties;
    private Class<?> cma_property;
    private Method cmaproperty_getvalue;
    private static final Long zero = 0L;
    private static final Gson gson = new GsonBuilder().create();

    protected BukkitVersionHelperGeneric() {
        if (this.nms_package == null) {
            this.failed = true;
        }
        this.craftworld = this.getOBCClass("org.bukkit.craftbukkit.CraftWorld");
        this.cw_gethandle = this.getMethod(this.craftworld, new String[]{"getHandle"}, new Class[0]);
        this.craftchunksnapshot = this.getOBCClass("org.bukkit.craftbukkit.CraftChunkSnapshot");
        this.biomebasearray = this.getNMSClass("[Lnet.minecraft.server.BiomeBase;");
        this.ccss_biome = this.getPrivateFieldNoFail(this.craftchunksnapshot, new String[]{"biome"}, this.biomebasearray);
        if (this.ccss_biome == null) {
            this.biomestorage = this.getNMSClass("net.minecraft.server.BiomeStorage");
            this.biomestoragebase = this.getPrivateField(this.biomestorage, new String[]{"h", "g", "f"}, this.biomebasearray);
            this.ccss_biome = this.getPrivateField(this.craftchunksnapshot, new String[]{"biome"}, this.biomestorage);
        }
        this.craftchunk = this.getOBCClass("org.bukkit.craftbukkit.CraftChunk");
        this.cc_gethandle = this.getMethod(this.craftchunk, new String[]{"getHandle"}, new Class[0]);
        this.server_getonlineplayers = this.getMethod(Server.class, new String[]{"getOnlinePlayers"}, new Class[0]);
        this.player_gethealth = this.getMethod(Player.class, new String[]{"getHealth"}, new Class[0]);
        this.obc_craftplayer = this.getOBCClass("org.bukkit.craftbukkit.entity.CraftPlayer");
        this.obcplayer_getprofile = this.getMethod(this.obc_craftplayer, new String[]{"getProfile"}, new Class[0]);
        this.cma_gameprofile = this.getOBCClass("com.mojang.authlib.GameProfile");
        this.cmaprofile_getproperties = this.getMethod(this.cma_gameprofile, new String[]{"getProperties"}, new Class[0]);
        this.cma_property = this.getOBCClass("com.mojang.authlib.properties.Property");
        this.cmaproperty_getvalue = this.getMethod(this.cma_property, new String[]{"getValue"}, new Class[0]);
        if (!this.failed) {
            this.loadNMS();
        }
        if (this.failed) {
            throw new IllegalArgumentException("Error initializing dynmap - bukkit version incompatible!");
        }
    }

    protected abstract void loadNMS();

    protected abstract String getNMSPackage();

    protected Class<?> getOBCClass(String classname) {
        return this.getClassByName(classname, "org.bukkit.craftbukkit", this.obc_package, false);
    }

    protected Class<?> getOBCClassNoFail(String classname) {
        return this.getClassByName(classname, "org.bukkit.craftbukkit", this.obc_package, true);
    }

    protected Class<?> getNMSClass(String classname) {
        return this.getClassByName(classname, "net.minecraft.server", this.nms_package, false);
    }

    protected Class<?> getNMSClassNoFail(String classname) {
        return this.getClassByName(classname, "net.minecraft.server", this.nms_package, true);
    }

    protected Class<?> getClassByName(String classname, String base, String mapping, boolean nofail) {
        String n = classname;
        int idx = classname.indexOf(base);
        if (idx >= 0) {
            n = classname.substring(0, idx) + mapping + classname.substring(idx + base.length());
        }
        try {
            return Class.forName(n);
        }
        catch (ClassNotFoundException cnfx) {
            try {
                return Class.forName(classname);
            }
            catch (ClassNotFoundException cnfx2) {
                if (!nofail) {
                    Log.severe("Cannot find " + classname);
                    this.failed = true;
                }
                return null;
            }
        }
    }

    protected Field getField(Class<?> cls, String[] ids, Class<?> type) {
        return this.getField(cls, ids, type, false);
    }

    protected Field getFieldNoFail(Class<?> cls, String[] ids, Class<?> type) {
        return this.getField(cls, ids, type, true);
    }

    private Field getField(Class<?> cls, String[] ids, Class<?> type, boolean nofail) {
        if (cls == null || type == null) {
            return null;
        }
        for (String id : ids) {
            try {
                Field f = cls.getField(id);
                if (!f.getType().isAssignableFrom(type)) continue;
                return f;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        if (!nofail) {
            Log.severe("Unable to find field " + ids[0] + " for " + cls.getName());
            this.failed = true;
        }
        return null;
    }

    protected Field getPrivateFieldNoFail(Class<?> cls, String[] ids, Class<?> type) {
        return this.getPrivateField(cls, ids, type, true);
    }

    protected Field getPrivateField(Class<?> cls, String[] ids, Class<?> type) {
        return this.getPrivateField(cls, ids, type, false);
    }

    protected Field getPrivateField(Class<?> cls, String[] ids, Class<?> type, boolean nofail) {
        if (cls == null || type == null) {
            return null;
        }
        for (String id : ids) {
            try {
                Field f = cls.getDeclaredField(id);
                if (!f.getType().isAssignableFrom(type)) continue;
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        if (!nofail) {
            Log.severe("Unable to find field " + ids[0] + " for " + cls.getName());
            this.failed = true;
        }
        return null;
    }

    protected Object getFieldValue(Object obj, Field field, Object def) {
        block4: {
            if (obj != null && field != null) {
                try {
                    return field.get(obj);
                }
                catch (IllegalArgumentException e) {
                    Log.warning(String.format("IllegalArgExc(%s,%s)", obj.toString(), field.toString()));
                    break block4;
                }
                catch (IllegalAccessException e) {
                    Log.warning(String.format("IllegalAccessExc(%s,%s)", obj.toString(), field.toString()));
                    break block4;
                }
            }
            Log.warning(String.format("NullArg(%s,%s)", obj != null ? obj.toString() : "null", field != null ? field.toString() : "null"));
        }
        return def;
    }

    protected Method getMethod(Class<?> cls, String[] ids, Class<?>[] args) {
        if (cls == null) {
            return null;
        }
        for (String id : ids) {
            try {
                return cls.getMethod(id, args);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        Log.severe("Unable to find method " + ids[0] + " for " + cls.getName());
        this.failed = true;
        return null;
    }

    protected Method getMethodNoFail(Class<?> cls, String[] ids, Class<?>[] args) {
        if (cls == null) {
            return null;
        }
        for (String id : ids) {
            try {
                return cls.getMethod(id, args);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Object callMethod(Object obj, Method meth, Object[] args, Object def) {
        if (obj == null || meth == null) {
            return def;
        }
        try {
            return meth.invoke(obj, args);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return def;
    }

    @Override
    public Object[] getBiomeBaseList() {
        Object baselist = this.getFieldValue(this.biomebase, this.biomebaselist, new Object[0]);
        if (this.biomestoragebase != null) {
            baselist = this.getFieldValue(baselist, this.biomestoragebase, new Object[0]);
        }
        return (Object[])baselist;
    }

    @Override
    public float getBiomeBaseTemperature(Object bb) {
        if (this.biomebasetempfunc != null) {
            return ((Float)this.callMethod(bb, this.biomebasetempfunc, new Object[0], Float.valueOf(0.5f))).floatValue();
        }
        return ((Float)this.getFieldValue(bb, this.biomebasetemp, Float.valueOf(0.5f))).floatValue();
    }

    @Override
    public float getBiomeBaseHumidity(Object bb) {
        if (this.biomebasehumifunc != null) {
            return ((Float)this.callMethod(bb, this.biomebasehumifunc, new Object[0], Float.valueOf(0.5f))).floatValue();
        }
        return ((Float)this.getFieldValue(bb, this.biomebasehumi, Float.valueOf(0.5f))).floatValue();
    }

    @Override
    public String getBiomeBaseIDString(Object bb) {
        return (String)this.getFieldValue(bb, this.biomebaseidstring, null);
    }

    @Override
    public int getBiomeBaseID(Object bb) {
        return (Integer)this.getFieldValue(bb, this.biomebaseid, -1);
    }

    protected Object getNMSWorld(World w) {
        return this.callMethod(w, this.cw_gethandle, nullargs, null);
    }

    @Override
    public Object getUnloadQueue(World world) {
        Object cps = this.getFieldValue(this.getNMSWorld(world), this.nmsw_chunkproviderserver, null);
        if (cps != null && this.cps_unloadqueue != null) {
            return this.getFieldValue(cps, this.cps_unloadqueue, null);
        }
        return null;
    }

    @Override
    public boolean isInUnloadQueue(Object unloadqueue, int x, int z) {
        if (unloadqueue != null) {
            if (this.cps_unloadqueue_isSet) {
                return ((Set)unloadqueue).contains((long)x & 0xFFFFFFFFFFFFFFFFL | ((long)z & 0xFFFFFFFFFFFFFFFFL) << 32);
            }
            return (Boolean)this.callMethod(unloadqueue, this.lhs_containskey, new Object[]{x, z}, true);
        }
        return true;
    }

    @Override
    public Object[] getBiomeBaseFromSnapshot(ChunkSnapshot css) {
        return (Object[])this.getFieldValue(css, this.ccss_biome, null);
    }

    @Override
    public long getInhabitedTicks(Chunk c) {
        if (this.nmsc_inhabitedticks == null) {
            return 0L;
        }
        Object omsc = this.callMethod(c, this.cc_gethandle, nullargs, null);
        if (omsc != null) {
            return (Long)this.getFieldValue(omsc, this.nmsc_inhabitedticks, zero);
        }
        return 0L;
    }

    @Override
    public Map<?, ?> getTileEntitiesForChunk(Chunk c) {
        Object omsc = this.callMethod(c, this.cc_gethandle, nullargs, null);
        if (omsc != null) {
            return (Map)this.getFieldValue(omsc, this.nmsc_tileentities, nullmap);
        }
        return nullmap;
    }

    @Override
    public int getTileEntityX(Object te) {
        if (this.nmst_getposition == null) {
            return (Integer)this.getFieldValue(te, this.nmst_x, 0);
        }
        Object pos = this.callMethod(te, this.nmst_getposition, nullargs, null);
        return (Integer)this.callMethod(pos, this.nmsbp_getx, nullargs, null);
    }

    @Override
    public int getTileEntityY(Object te) {
        if (this.nmst_getposition == null) {
            return (Integer)this.getFieldValue(te, this.nmst_y, 0);
        }
        Object pos = this.callMethod(te, this.nmst_getposition, nullargs, null);
        return (Integer)this.callMethod(pos, this.nmsbp_gety, nullargs, null);
    }

    @Override
    public int getTileEntityZ(Object te) {
        if (this.nmst_getposition == null) {
            return (Integer)this.getFieldValue(te, this.nmst_z, 0);
        }
        Object pos = this.callMethod(te, this.nmst_getposition, nullargs, null);
        return (Integer)this.callMethod(pos, this.nmsbp_getz, nullargs, null);
    }

    @Override
    public Object readTileEntityNBT(Object te, World w) {
        if (this.nbttagcompound == null) {
            return null;
        }
        Object nbt = null;
        try {
            nbt = this.nbttagcompound.newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (nbt != null) {
            this.callMethod(te, this.nmst_readnbt, new Object[]{nbt}, null);
        }
        return nbt;
    }

    @Override
    public Object getFieldValue(Object nbt, String field) {
        Object val = this.callMethod(nbt, this.compound_get, new Object[]{field}, null);
        if (val == null) {
            return null;
        }
        Class<?> valcls = val.getClass();
        if (valcls.equals(this.nbttagbyte)) {
            return this.getFieldValue(val, this.nbttagbyte_val, null);
        }
        if (valcls.equals(this.nbttagshort)) {
            return this.getFieldValue(val, this.nbttagshort_val, null);
        }
        if (valcls.equals(this.nbttagint)) {
            return this.getFieldValue(val, this.nbttagint_val, null);
        }
        if (valcls.equals(this.nbttaglong)) {
            return this.getFieldValue(val, this.nbttaglong_val, null);
        }
        if (valcls.equals(this.nbttagfloat)) {
            return this.getFieldValue(val, this.nbttagfloat_val, null);
        }
        if (valcls.equals(this.nbttagdouble)) {
            return this.getFieldValue(val, this.nbttagdouble_val, null);
        }
        if (valcls.equals(this.nbttagbytearray)) {
            return this.getFieldValue(val, this.nbttagbytearray_val, null);
        }
        if (valcls.equals(this.nbttagstring)) {
            return this.getFieldValue(val, this.nbttagstring_val, null);
        }
        if (valcls.equals(this.nbttagintarray)) {
            return this.getFieldValue(val, this.nbttagintarray_val, null);
        }
        return null;
    }

    @Override
    public Player[] getOnlinePlayers() {
        Object players = this.callMethod(Bukkit.getServer(), this.server_getonlineplayers, nullargs, null);
        if (players instanceof Player[]) {
            return (Player[])players;
        }
        Collection p = (Collection)players;
        return p.toArray(new Player[0]);
    }

    @Override
    public double getHealth(Player p) {
        Object health = this.callMethod(p, this.player_gethealth, nullargs, null);
        if (health instanceof Integer) {
            return ((Integer)health).intValue();
        }
        return ((Double)health).intValue();
    }

    @Override
    public String getSkinURL(Player player) {
        Object propmap;
        String url = null;
        Object profile = this.callMethod(player, this.obcplayer_getprofile, nullargs, null);
        if (profile != null && (propmap = this.callMethod(profile, this.cmaprofile_getproperties, nullargs, null)) != null && propmap instanceof ForwardingMultimap) {
            String val;
            ForwardingMultimap fmm = (ForwardingMultimap)propmap;
            Collection txt = fmm.get((Object)"textures");
            Object textureProperty = Iterables.getFirst((Iterable)fmm.get((Object)"textures"), null);
            if (textureProperty != null && (val = (String)this.callMethod(textureProperty, this.cmaproperty_getvalue, nullargs, null)) != null) {
                TexturesPayload result = null;
                try {
                    String json = new String(Base64.getDecoder().decode(val), StandardCharsets.UTF_8);
                    result = (TexturesPayload)gson.fromJson(json, TexturesPayload.class);
                }
                catch (JsonParseException json) {
                }
                catch (IllegalArgumentException x) {
                    Log.warning("Malformed response from skin URL check: " + val);
                }
                if (result != null && result.textures != null && result.textures.containsKey("SKIN")) {
                    url = result.textures.get((Object)"SKIN").url;
                }
            }
        }
        return url;
    }

    public class TexturesPayload {
        public long timestamp;
        public String profileId;
        public String profileName;
        public boolean isPublic;
        public Map<String, ProfileTexture> textures;
    }

    public class ProfileTexture {
        public String url;
    }
}

