/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import java.util.List;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapWorld;
import org.dynmap.MapManager;
import org.dynmap.MapTile;
import org.dynmap.hdmap.HDPerspective;
import org.dynmap.utils.MapChunkCache;

public class HDMapTile
extends MapTile {
    public final HDPerspective perspective;
    public final int tx;
    public final int ty;
    public final int boostzoom;

    public HDMapTile(DynmapWorld world, HDPerspective perspective, int tx, int ty, int boostzoom) {
        super(world);
        this.perspective = perspective;
        this.tx = tx;
        this.ty = ty;
        this.boostzoom = boostzoom;
    }

    public HDMapTile(DynmapWorld world, String parm) throws Exception {
        super(world);
        String[] parms = parm.split(",");
        if (parms.length < 3) {
            throw new Exception("wrong parameter count");
        }
        this.tx = Integer.parseInt(parms[0]);
        this.ty = Integer.parseInt(parms[1]);
        this.perspective = MapManager.mapman.hdmapman.perspectives.get(parms[2]);
        if (this.perspective == null) {
            throw new Exception("invalid perspective");
        }
        this.boostzoom = parms.length > 3 ? Integer.parseInt(parms[3]) : 0;
    }

    @Override
    protected String saveTileData() {
        return String.format("%d,%d,%s,%d", this.tx, this.ty, this.perspective.getName(), this.boostzoom);
    }

    @Override
    public int hashCode() {
        return this.tx ^ this.ty ^ this.perspective.hashCode() ^ this.world.hashCode() ^ this.boostzoom;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof HDMapTile) {
            return this.equals((HDMapTile)obj);
        }
        return false;
    }

    public boolean equals(HDMapTile o) {
        return o.tx == this.tx && o.ty == this.ty && this.perspective == o.perspective && o.world == this.world && o.boostzoom == this.boostzoom;
    }

    public String toString() {
        return this.world.getName() + ":" + this.perspective.getName() + "," + this.tx + "," + this.ty + ":" + this.boostzoom;
    }

    @Override
    public boolean isBiomeDataNeeded() {
        return MapManager.mapman.hdmapman.isBiomeDataNeeded(this);
    }

    @Override
    public boolean isHightestBlockYDataNeeded() {
        return MapManager.mapman.hdmapman.isHightestBlockYDataNeeded(this);
    }

    @Override
    public boolean isRawBiomeDataNeeded() {
        return MapManager.mapman.hdmapman.isRawBiomeDataNeeded(this);
    }

    @Override
    public boolean isBlockTypeDataNeeded() {
        return MapManager.mapman.hdmapman.isBlockTypeDataNeeded(this);
    }

    @Override
    public boolean render(MapChunkCache cache, String mapname) {
        return this.perspective.render(cache, this, mapname);
    }

    @Override
    public List<DynmapChunk> getRequiredChunks() {
        return this.perspective.getRequiredChunks(this);
    }

    @Override
    public MapTile[] getAdjecentTiles() {
        return this.perspective.getAdjecentTiles(this);
    }

    @Override
    public int tileOrdinalX() {
        return this.tx;
    }

    @Override
    public int tileOrdinalY() {
        return this.ty;
    }
}

