/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit.permissions;

import com.nijiko.permissions.PermissionHandler;
import com.nijikokun.bukkit.Permissions.Permissions;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.dynmap.Log;
import org.dynmap.bukkit.permissions.PermissionProvider;

public class NijikokunPermissions
implements PermissionProvider {
    String name;
    PermissionHandler permissions;
    Plugin plugin;
    String defworld;

    public static NijikokunPermissions create(Server server, String name) {
        Plugin permissionsPlugin = server.getPluginManager().getPlugin("Permissions");
        if (permissionsPlugin == null) {
            return null;
        }
        server.getPluginManager().enablePlugin(permissionsPlugin);
        if (!permissionsPlugin.isEnabled()) {
            return null;
        }
        Log.info("Using Permissions " + permissionsPlugin.getDescription().getVersion() + " for access control");
        return new NijikokunPermissions(permissionsPlugin, name);
    }

    public NijikokunPermissions(Plugin permissionsPlugin, String name) {
        this.name = name;
        this.plugin = permissionsPlugin;
        this.defworld = ((World)Bukkit.getServer().getWorlds().get(0)).getName();
    }

    @Override
    public boolean has(CommandSender sender, String permission) {
        Player player;
        if (this.permissions == null) {
            this.permissions = ((Permissions)this.plugin).getHandler();
        }
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        return player != null ? this.permissions.has(player, this.name + "." + permission) || this.permissions.has(player, this.name + ".*") : true;
    }

    @Override
    public Set<String> hasOfflinePermissions(String player, Set<String> perms) {
        if (this.permissions == null) {
            this.permissions = ((Permissions)this.plugin).getHandler();
        }
        HashSet<String> hasperms = new HashSet<String>();
        for (String pp : perms) {
            if (!this.permissions.has(this.defworld, player, this.name + "." + pp)) continue;
            hasperms.add(pp);
        }
        return hasperms;
    }

    @Override
    public boolean hasOfflinePermission(String player, String perm) {
        if (this.permissions == null) {
            this.permissions = ((Permissions)this.plugin).getHandler();
        }
        return this.permissions.has(this.defworld, player, this.name + "." + perm);
    }
}

