/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit.helper.v116_4;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.server.v1_16_R3.BiomeBase;
import net.minecraft.server.v1_16_R3.Block;
import net.minecraft.server.v1_16_R3.BlockFluids;
import net.minecraft.server.v1_16_R3.BlockRotatable;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.IRegistry;
import net.minecraft.server.v1_16_R3.Material;
import net.minecraft.server.v1_16_R3.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.entity.Player;
import org.dynmap.DynmapChunk;
import org.dynmap.Log;
import org.dynmap.bukkit.helper.BukkitMaterial;
import org.dynmap.bukkit.helper.BukkitVersionHelperGeneric;
import org.dynmap.bukkit.helper.BukkitWorld;
import org.dynmap.bukkit.helper.v116_4.MapChunkCache116_4;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.Polygon;

public class BukkitVersionHelperSpigot116_4
extends BukkitVersionHelperGeneric {
    private Field watercolorfield;
    private IRegistry<BiomeBase> reg = null;
    private Object[] biomelist;
    public static IdentityHashMap<IBlockData, DynmapBlockState> dataToState;
    private String[] biomenames;

    public BukkitVersionHelperSpigot116_4() {
        Class<?> biomefog = this.getNMSClass("net.minecraft.server.BiomeFog");
        this.watercolorfield = this.getPrivateField(biomefog, new String[]{"c"}, Integer.TYPE);
    }

    @Override
    public String[] getBlockNames() {
        int cnt = Block.REGISTRY_ID.a();
        String[] names = new String[cnt];
        for (int i = 0; i < cnt; ++i) {
            IBlockData bd = Block.getByCombinedId((int)i);
            names[i] = IRegistry.BLOCK.getKey((Object)bd.getBlock()).toString();
            Log.info(i + ": blk=" + names[i] + ", bd=" + bd.toString());
        }
        return names;
    }

    private IRegistry<BiomeBase> getBiomeReg() {
        if (this.reg == null) {
            this.reg = MinecraftServer.getServer().getCustomRegistry().b(IRegistry.ay);
        }
        return this.reg;
    }

    @Override
    public Object[] getBiomeBaseList() {
        if (this.biomelist == null) {
            this.biomelist = new Object[1024];
            for (int i = 0; i < 1024; ++i) {
                this.biomelist[i] = this.getBiomeReg().fromId(i);
            }
        }
        return this.biomelist;
    }

    @Override
    public int getBiomeBaseID(Object bb) {
        return this.getBiomeReg().a((Object)((BiomeBase)bb));
    }

    @Override
    public void initializeBlockStates() {
        dataToState = new IdentityHashMap();
        HashMap<String, DynmapBlockState> lastBlockState = new HashMap<String, DynmapBlockState>();
        int cnt = Block.REGISTRY_ID.a();
        for (int i = 0; i < cnt; ++i) {
            IBlockData bd = Block.getByCombinedId((int)i);
            String bname = IRegistry.BLOCK.getKey((Object)bd.getBlock()).toString();
            DynmapBlockState lastbs = (DynmapBlockState)lastBlockState.get(bname);
            int idx = 0;
            if (lastbs != null) {
                idx = lastbs.getStateCount();
            }
            String sb = "";
            String fname = bd.toString();
            int off1 = fname.indexOf(91);
            if (off1 >= 0) {
                int off2 = fname.indexOf(93);
                sb = fname.substring(off1 + 1, off2);
            }
            Material mat = bd.getMaterial();
            DynmapBlockState bs = new DynmapBlockState(lastbs, idx, bname, sb, mat.toString());
            if (!bd.getFluid().isEmpty() && !(bd.getBlock() instanceof BlockFluids)) {
                bs.setWaterlogged();
            }
            if (mat == Material.AIR) {
                bs.setAir();
            }
            if (mat == Material.LEAVES) {
                bs.setLeaves();
            }
            if (bd.getBlock() instanceof BlockRotatable && bd.getMaterial() == Material.WOOD) {
                bs.setLog();
            }
            if (mat.isSolid()) {
                bs.setSolid();
            }
            dataToState.put(bd, bs);
            lastBlockState.put(bname, lastbs == null ? bs : lastbs);
            Log.verboseinfo(i + ": blk=" + bname + ", idx=" + idx + ", state=" + sb + ", waterlogged=" + bs.isWaterlogged());
        }
    }

    @Override
    public MapChunkCache getChunkCache(BukkitWorld dw, List<DynmapChunk> chunks) {
        MapChunkCache116_4 c = new MapChunkCache116_4();
        c.setChunks(dw, chunks);
        return c;
    }

    @Override
    public int getBiomeBaseWaterMult(Object bb) {
        try {
            return (Integer)this.watercolorfield.get(((BiomeBase)bb).l());
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return 0xFFFFFF;
    }

    @Override
    public float getBiomeBaseTemperature(Object bb) {
        return ((BiomeBase)bb).k();
    }

    @Override
    public float getBiomeBaseHumidity(Object bb) {
        return ((BiomeBase)bb).getHumidity();
    }

    @Override
    public Polygon getWorldBorder(World world) {
        Polygon p = null;
        WorldBorder wb = world.getWorldBorder();
        if (wb != null) {
            Location c = wb.getCenter();
            double size = wb.getSize();
            if (size > 1.0 && size < 1.0E7) {
                p = new Polygon();
                p.addVertex(c.getX() - (size /= 2.0), c.getZ() - size);
                p.addVertex(c.getX() + size, c.getZ() - size);
                p.addVertex(c.getX() + size, c.getZ() + size);
                p.addVertex(c.getX() - size, c.getZ() + size);
            }
        }
        return p;
    }

    @Override
    public void sendTitleText(Player p, String title, String subtitle, int fadeInTicks, int stayTicks, int fadeOutTIcks) {
        if (p != null) {
            p.sendTitle(title, subtitle, fadeInTicks, stayTicks, fadeOutTIcks);
        }
    }

    @Override
    public BukkitMaterial[] getMaterialList() {
        return new BukkitMaterial[4096];
    }

    @Override
    protected void loadNMS() {
    }

    @Override
    protected String getNMSPackage() {
        Server srv = Bukkit.getServer();
        try {
            Method m = srv.getClass().getMethod("getHandle", new Class[0]);
            Object scm = m.invoke((Object)srv, new Object[0]);
            return scm.getClass().getPackage().getName();
        }
        catch (Exception x) {
            Log.severe("Error finding net.minecraft.server packages");
            return null;
        }
    }

    @Override
    public void unloadChunkNoSave(World w, Chunk c, int cx, int cz) {
        Log.severe("unloadChunkNoSave not implemented");
    }

    @Override
    public String[] getBiomeNames() {
        if (this.biomenames == null) {
            this.biomenames = new String[1024];
            for (int i = 0; i < 1024; ++i) {
                BiomeBase bb = (BiomeBase)this.getBiomeReg().fromId(i);
                if (bb == null) continue;
                this.biomenames[i] = bb.toString();
            }
        }
        return this.biomenames;
    }

    @Override
    public String getStateStringByCombinedId(int blkid, int meta) {
        Log.severe("getStateStringByCombinedId not implemented");
        return null;
    }

    @Override
    public String getBiomeBaseIDString(Object bb) {
        String s = ((BiomeBase)bb).toString();
        if (s != null) {
            String[] ss = s.split("\\.");
            return ss[ss.length - 1];
        }
        return null;
    }
}

