/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit.helper.v116_3;

import java.io.IOException;
import java.util.Arrays;
import net.minecraft.server.v1_16_R2.Chunk;
import net.minecraft.server.v1_16_R2.ChunkCoordIntPair;
import net.minecraft.server.v1_16_R2.ChunkRegionLoader;
import net.minecraft.server.v1_16_R2.ChunkStatus;
import net.minecraft.server.v1_16_R2.DataBits;
import net.minecraft.server.v1_16_R2.DataBitsPacked;
import net.minecraft.server.v1_16_R2.IChunkAccess;
import net.minecraft.server.v1_16_R2.NBTTagCompound;
import net.minecraft.server.v1_16_R2.NBTTagList;
import net.minecraft.server.v1_16_R2.WorldServer;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_16_R2.CraftWorld;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapCore;
import org.dynmap.bukkit.helper.AbstractMapChunkCache;
import org.dynmap.bukkit.helper.BukkitVersionHelper;
import org.dynmap.bukkit.helper.SnapshotCache;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.VisibilityLimit;

public class MapChunkCache116_3
extends AbstractMapChunkCache {
    private NBTTagCompound fetchLoadedChunkNBT(World w, int x, int z) {
        Chunk c;
        CraftWorld cw = (CraftWorld)w;
        NBTTagCompound nbt = null;
        if (cw.isChunkLoaded(x, z) && (c = cw.getHandle().getChunkAt(x, z)) != null && c.loaded) {
            nbt = ChunkRegionLoader.saveChunk((WorldServer)cw.getHandle(), (IChunkAccess)c);
        }
        if (nbt != null && (nbt = nbt.getCompound("Level")) != null) {
            String stat = nbt.getString("Status");
            ChunkStatus cs = ChunkStatus.a((String)stat);
            if (stat == null || !cs.b(ChunkStatus.LIGHT)) {
                nbt = null;
            }
        }
        return nbt;
    }

    private NBTTagCompound loadChunkNBT(World w, int x, int z) {
        String stat;
        CraftWorld cw = (CraftWorld)w;
        NBTTagCompound nbt = null;
        ChunkCoordIntPair cc = new ChunkCoordIntPair(x, z);
        try {
            nbt = cw.getHandle().getChunkProvider().playerChunkMap.read(cc);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!(nbt == null || (nbt = nbt.getCompound("Level")) == null || (stat = nbt.getString("Status")) != null && stat.equals("full"))) {
            Chunk c;
            nbt = null;
            if ((stat == null || stat.equals("") && DynmapCore.migrateChunks()) && (c = cw.getHandle().getChunkAt(x, z)) != null) {
                nbt = this.fetchLoadedChunkNBT(w, x, z);
                cw.getHandle().unloadChunk(c);
            }
        }
        return nbt;
    }

    @Override
    public AbstractMapChunkCache.Snapshot wrapChunkSnapshot(ChunkSnapshot css) {
        return null;
    }

    @Override
    public int loadChunks(int max_to_load) {
        if (!this.dw.isLoaded()) {
            return 0;
        }
        int cnt = 0;
        if (this.iterator == null) {
            this.iterator = this.chunks.listIterator();
        }
        DynmapCore.setIgnoreChunkLoads(true);
        while (cnt < max_to_load && this.iterator.hasNext()) {
            long startTime = System.nanoTime();
            DynmapChunk chunk = (DynmapChunk)this.iterator.next();
            boolean vis = true;
            if (this.visible_limits != null) {
                vis = false;
                for (VisibilityLimit limit : this.visible_limits) {
                    if (!limit.doIntersectChunk(chunk.x, chunk.z)) continue;
                    vis = true;
                    break;
                }
            }
            if (vis && this.hidden_limits != null) {
                for (VisibilityLimit limit : this.hidden_limits) {
                    if (!limit.doIntersectChunk(chunk.x, chunk.z)) continue;
                    vis = false;
                    break;
                }
            }
            AbstractMapChunkCache.Snapshot ss = null;
            long inhabited_ticks = 0L;
            Object tileData = null;
            int idx = chunk.x - this.x_min + (chunk.z - this.z_min) * this.x_dim;
            SnapshotCache.SnapshotRec ssr = SnapshotCache.sscache.getSnapshot(this.dw.getName(), chunk.x, chunk.z, this.blockdata, this.biome, this.biomeraw, this.highesty);
            if (ssr != null) {
                inhabited_ticks = ssr.inhabitedTicks;
                ss = !vis ? (this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_STONE_PLAIN ? STONE : (this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_OCEAN ? OCEAN : EMPTY)) : ssr.ss;
                this.snaparray[idx] = ss;
                this.snaptile[idx] = ssr.tileData;
                this.inhabitedTicks[idx] = inhabited_ticks;
                this.endChunkLoad(startTime, MapChunkCache.ChunkStats.CACHED_SNAPSHOT_HIT);
                continue;
            }
            NBTTagCompound nbt = this.fetchLoadedChunkNBT(this.w, chunk.x, chunk.z);
            boolean did_load = false;
            if (nbt == null) {
                nbt = this.loadChunkNBT(this.w, chunk.x, chunk.z);
                did_load = true;
            }
            if (nbt != null) {
                NBTSnapshot nss = new NBTSnapshot(nbt, this.w.getMaxHeight());
                ss = nss;
                inhabited_ticks = nss.getInhabitedTicks();
                if (!vis) {
                    ss = this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_STONE_PLAIN ? STONE : (this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_OCEAN ? OCEAN : EMPTY);
                }
            } else {
                ss = EMPTY;
            }
            ssr = new SnapshotCache.SnapshotRec();
            ssr.ss = ss;
            ssr.inhabitedTicks = inhabited_ticks;
            ssr.tileData = tileData;
            SnapshotCache.sscache.putSnapshot(this.dw.getName(), chunk.x, chunk.z, ssr, this.blockdata, this.biome, this.biomeraw, this.highesty);
            this.snaparray[idx] = ss;
            this.snaptile[idx] = ssr.tileData;
            this.inhabitedTicks[idx] = inhabited_ticks;
            if (nbt == null) {
                this.endChunkLoad(startTime, MapChunkCache.ChunkStats.UNGENERATED_CHUNKS);
            } else if (did_load) {
                this.endChunkLoad(startTime, MapChunkCache.ChunkStats.UNLOADED_CHUNKS);
            } else {
                this.endChunkLoad(startTime, MapChunkCache.ChunkStats.LOADED_CHUNKS);
            }
            ++cnt;
        }
        DynmapCore.setIgnoreChunkLoads(false);
        if (!this.iterator.hasNext()) {
            this.isempty = true;
            for (int i = 0; i < this.snaparray.length; ++i) {
                if (this.snaparray[i] == null) {
                    this.snaparray[i] = EMPTY;
                    continue;
                }
                if (this.snaparray[i] == EMPTY) continue;
                this.isempty = false;
            }
        }
        return cnt;
    }

    public static class NBTSnapshot
    implements AbstractMapChunkCache.Snapshot {
        private final int x;
        private final int z;
        private final Section[] section;
        private final int[] hmap;
        private final int[] biome;
        private final Object[] biomebase;
        private final long captureFulltime;
        private final int sectionCnt;
        private final long inhabitedTicks;
        private static final int BLOCKS_PER_SECTION = 4096;
        private static final int COLUMNS_PER_CHUNK = 256;
        private static final int V1_15_BIOME_PER_CHUNK = 1024;
        private static final byte[] emptyData = new byte[2048];
        private static final byte[] fullData = new byte[2048];
        private static final EmptySection empty_section;

        private static byte[] dataCopy(byte[] v) {
            if (Arrays.equals(v, emptyData)) {
                return emptyData;
            }
            if (Arrays.equals(v, fullData)) {
                return fullData;
            }
            return (byte[])v.clone();
        }

        public NBTSnapshot(int worldheight, int x, int z, long captime, long inhabitedTime) {
            this.x = x;
            this.z = z;
            this.captureFulltime = captime;
            this.biome = new int[256];
            this.biomebase = new Object[256];
            this.sectionCnt = worldheight / 16;
            this.section = new Section[this.sectionCnt];
            for (int i = 0; i < this.sectionCnt; ++i) {
                this.section[i] = empty_section;
            }
            this.hmap = new int[256];
            this.inhabitedTicks = inhabitedTime;
        }

        public NBTSnapshot(NBTTagCompound nbt, int worldheight) {
            block21: {
                int i;
                int[] bb;
                this.x = nbt.getInt("xPos");
                this.z = nbt.getInt("zPos");
                this.captureFulltime = 0L;
                this.hmap = nbt.getIntArray("HeightMap");
                this.sectionCnt = worldheight / 16;
                this.inhabitedTicks = nbt.hasKey("InhabitedTime") ? nbt.getLong("InhabitedTime") : 0L;
                this.section = new Section[this.sectionCnt];
                for (int i2 = 0; i2 < this.sectionCnt; ++i2) {
                    this.section[i2] = empty_section;
                }
                NBTTagList sect = nbt.getList("Sections", 10);
                for (int i3 = 0; i3 < sect.size(); ++i3) {
                    NBTTagCompound sec = sect.getCompound(i3);
                    byte secnum = sec.getByte("Y");
                    if (secnum >= this.sectionCnt || secnum < 0) continue;
                    StdSection cursect = new StdSection();
                    this.section[secnum] = cursect;
                    DynmapBlockState[] states = cursect.states;
                    DynmapBlockState[] palette = null;
                    if (sec.hasKeyOfType("Palette", 9) && sec.hasKeyOfType("BlockStates", 12)) {
                        int j;
                        NBTTagList plist = sec.getList("Palette", 10);
                        long[] statelist = sec.getLongArray("BlockStates");
                        palette = new DynmapBlockState[plist.size()];
                        for (int pi = 0; pi < plist.size(); ++pi) {
                            NBTTagCompound tc = plist.getCompound(pi);
                            String pname = tc.getString("Name");
                            if (tc.hasKey("Properties")) {
                                StringBuilder statestr = new StringBuilder();
                                NBTTagCompound prop = tc.getCompound("Properties");
                                for (String pid : prop.getKeys()) {
                                    if (statestr.length() > 0) {
                                        statestr.append(',');
                                    }
                                    statestr.append(pid).append('=').append(prop.get(pid).asString());
                                }
                                palette[pi] = DynmapBlockState.getStateByNameAndState(pname, statestr.toString());
                            }
                            if (palette[pi] == null) {
                                palette[pi] = DynmapBlockState.getBaseStateByName(pname);
                            }
                            if (palette[pi] != null) continue;
                            palette[pi] = DynmapBlockState.AIR;
                        }
                        int recsperblock = (4096 + statelist.length - 1) / statelist.length;
                        int bitsperblock = 64 / recsperblock;
                        DataBits db = null;
                        DataBitsPacked dbp = null;
                        try {
                            db = new DataBits(bitsperblock, 4096, statelist);
                        }
                        catch (Exception x) {
                            bitsperblock = statelist.length * 64 / 4096;
                            dbp = new DataBitsPacked(bitsperblock, 4096, statelist);
                        }
                        if (bitsperblock > 8) {
                            for (j = 0; j < 4096; ++j) {
                                int v = db != null ? db.a(j) : dbp.a(j);
                                states[j] = DynmapBlockState.getStateByGlobalIndex(v);
                            }
                        } else {
                            for (j = 0; j < 4096; ++j) {
                                int v = db != null ? db.a(j) : dbp.a(j);
                                states[j] = v < palette.length ? palette[v] : DynmapBlockState.AIR;
                            }
                        }
                    }
                    if (sec.hasKey("BlockLight")) {
                        cursect.emitlight = NBTSnapshot.dataCopy(sec.getByteArray("BlockLight"));
                    }
                    if (!sec.hasKey("SkyLight")) continue;
                    cursect.skylight = NBTSnapshot.dataCopy(sec.getByteArray("SkyLight"));
                }
                this.biome = new int[256];
                this.biomebase = new Object[256];
                Object[] bbl = BukkitVersionHelper.helper.getBiomeBaseList();
                if (!nbt.hasKey("Biomes") || (bb = nbt.getIntArray("Biomes")) == null) break block21;
                if (bb.length > 256) {
                    for (i = 0; i < 256; ++i) {
                        int off = (i >> 4 & 0xC) + (i >> 2 & 3);
                        int bv = bb[off + 64];
                        if (bv < 0) {
                            bv = 0;
                        }
                        this.biome[i] = bv;
                        this.biomebase[i] = bbl[bv];
                    }
                } else {
                    for (i = 0; i < bb.length; ++i) {
                        int bv = bb[i];
                        if (bv < 0) {
                            bv = 0;
                        }
                        this.biome[i] = bv;
                        this.biomebase[i] = bbl[bv];
                    }
                }
            }
        }

        public int getX() {
            return this.x;
        }

        public int getZ() {
            return this.z;
        }

        @Override
        public DynmapBlockState getBlockType(int x, int y, int z) {
            return this.section[y >> 4].getBlockType(x, y, z);
        }

        @Override
        public int getBlockSkyLight(int x, int y, int z) {
            return this.section[y >> 4].getBlockSkyLight(x, y, z);
        }

        @Override
        public int getBlockEmittedLight(int x, int y, int z) {
            return this.section[y >> 4].getBlockEmittedLight(x, y, z);
        }

        @Override
        public int getHighestBlockYAt(int x, int z) {
            return this.hmap[z << 4 | x];
        }

        public final long getCaptureFullTime() {
            return this.captureFulltime;
        }

        @Override
        public boolean isSectionEmpty(int sy) {
            return this.section[sy].isEmpty();
        }

        public long getInhabitedTicks() {
            return this.inhabitedTicks;
        }

        @Override
        public Biome getBiome(int x, int z) {
            return AbstractMapChunkCache.getBiomeByID(this.biome[z << 4 | x]);
        }

        @Override
        public Object[] getBiomeBaseFromSnapshot() {
            return this.biomebase;
        }

        static {
            Arrays.fill(fullData, (byte)-1);
            empty_section = new EmptySection();
        }

        private static class StdSection
        implements Section {
            DynmapBlockState[] states = new DynmapBlockState[4096];
            byte[] skylight;
            byte[] emitlight;

            public StdSection() {
                Arrays.fill(this.states, DynmapBlockState.AIR);
                this.skylight = emptyData;
                this.emitlight = emptyData;
            }

            @Override
            public DynmapBlockState getBlockType(int x, int y, int z) {
                return this.states[(y & 0xF) << 8 | z << 4 | x];
            }

            @Override
            public int getBlockSkyLight(int x, int y, int z) {
                int off = (y & 0xF) << 7 | z << 3 | x >> 1;
                return this.skylight[off] >> 4 * (x & 1) & 0xF;
            }

            @Override
            public int getBlockEmittedLight(int x, int y, int z) {
                int off = (y & 0xF) << 7 | z << 3 | x >> 1;
                return this.emitlight[off] >> 4 * (x & 1) & 0xF;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }
        }

        private static class EmptySection
        implements Section {
            private EmptySection() {
            }

            @Override
            public DynmapBlockState getBlockType(int x, int y, int z) {
                return DynmapBlockState.AIR;
            }

            @Override
            public int getBlockSkyLight(int x, int y, int z) {
                return 15;
            }

            @Override
            public int getBlockEmittedLight(int x, int y, int z) {
                return 0;
            }

            @Override
            public boolean isEmpty() {
                return true;
            }
        }

        private static interface Section {
            public DynmapBlockState getBlockType(int var1, int var2, int var3);

            public int getBlockSkyLight(int var1, int var2, int var3);

            public int getBlockEmittedLight(int var1, int var2, int var3);

            public boolean isEmpty();
        }
    }
}

