/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit.helper;

import org.bukkit.ChunkSnapshot;
import org.bukkit.block.Biome;
import org.dynmap.bukkit.helper.AbstractMapChunkCache;
import org.dynmap.bukkit.helper.BukkitVersionHelper;
import org.dynmap.renderer.DynmapBlockState;

public class MapChunkCacheClassic
extends AbstractMapChunkCache {
    @Override
    public AbstractMapChunkCache.Snapshot wrapChunkSnapshot(ChunkSnapshot css) {
        return new WrappedSnapshot(css);
    }

    public static class WrappedSnapshot
    implements AbstractMapChunkCache.Snapshot {
        private final ChunkSnapshot ss;
        private final int sectionmask;

        public WrappedSnapshot(ChunkSnapshot ss) {
            this.ss = ss;
            int mask = 0;
            for (int i = 0; i < 16; ++i) {
                if (!ss.isSectionEmpty(i)) continue;
                mask |= 1 << i;
            }
            this.sectionmask = mask;
        }

        @Override
        public final DynmapBlockState getBlockType(int x, int y, int z) {
            if ((this.sectionmask & 1 << (y >> 4)) != 0) {
                return DynmapBlockState.AIR;
            }
            return BukkitVersionHelper.stateByID[this.ss.getBlockTypeId(x, y, z) << 4 | this.ss.getBlockData(x, y, z)];
        }

        @Override
        public final int getBlockSkyLight(int x, int y, int z) {
            return this.ss.getBlockSkyLight(x, y, z);
        }

        @Override
        public final int getBlockEmittedLight(int x, int y, int z) {
            return this.ss.getBlockEmittedLight(x, y, z);
        }

        @Override
        public final int getHighestBlockYAt(int x, int z) {
            return this.ss.getHighestBlockYAt(x, z);
        }

        @Override
        public final Biome getBiome(int x, int z) {
            return this.ss.getBiome(x, z);
        }

        @Override
        public final boolean isSectionEmpty(int sy) {
            return (this.sectionmask & 1 << sy) != 0;
        }

        @Override
        public final Object[] getBiomeBaseFromSnapshot() {
            return BukkitVersionHelper.helper.getBiomeBaseFromSnapshot(this.ss);
        }
    }
}

