/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.bukkit.helper.BukkitVersionHelper;
import org.dynmap.bukkit.helper.BukkitWorld;
import org.dynmap.bukkit.helper.SnapshotCache;
import org.dynmap.common.BiomeMap;
import org.dynmap.hdmap.HDBlockModels;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.renderer.RenderPatchFactory;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.DynIntHashMap;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;
import org.dynmap.utils.VisibilityLimit;

public abstract class AbstractMapChunkCache
extends MapChunkCache {
    private static boolean init;
    protected World w;
    protected DynmapWorld dw;
    private int nsect;
    protected List<DynmapChunk> chunks;
    protected ListIterator<DynmapChunk> iterator;
    protected int x_min;
    private int x_max;
    protected int z_min;
    private int z_max;
    protected int x_dim;
    protected boolean biome;
    protected boolean biomeraw;
    protected boolean highesty;
    protected boolean blockdata;
    protected MapChunkCache.HiddenChunkStyle hidestyle = MapChunkCache.HiddenChunkStyle.FILL_AIR;
    protected List<VisibilityLimit> visible_limits = null;
    protected List<VisibilityLimit> hidden_limits = null;
    protected boolean isempty = true;
    private int snapcnt;
    protected Snapshot[] snaparray;
    protected DynIntHashMap[] snaptile;
    private byte[][] sameneighborbiomecnt;
    private BiomeMap[][] biomemap;
    private boolean[][] isSectionNotEmpty;
    protected long[] inhabitedTicks;
    private static final BiomeMap[] nullBiomeMap;
    private static final BlockStep[] unstep;
    private static BiomeMap[] biome_to_bmap;
    private static Biome[] biome_by_id;
    protected static final EmptyChunk EMPTY;
    protected static final PlainChunk STONE;
    protected static final PlainChunk OCEAN;

    protected static final int getIndexInChunk(int cx, int cy, int cz) {
        return cy << 8 | cz << 4 | cx;
    }

    public AbstractMapChunkCache() {
        if (!init) {
            init = true;
        }
    }

    public void setChunks(BukkitWorld dw, List<DynmapChunk> chunks) {
        this.dw = dw;
        this.w = dw.getWorld();
        if (this.w == null) {
            this.chunks = new ArrayList<DynmapChunk>();
        }
        this.nsect = dw.worldheight >> 4;
        this.chunks = chunks;
        if (chunks.size() == 0) {
            this.x_min = 0;
            this.x_max = 0;
            this.z_min = 0;
            this.z_max = 0;
            this.x_dim = 1;
        } else {
            this.x_min = this.x_max = chunks.get((int)0).x;
            this.z_min = this.z_max = chunks.get((int)0).z;
            for (DynmapChunk c : chunks) {
                if (c.x > this.x_max) {
                    this.x_max = c.x;
                }
                if (c.x < this.x_min) {
                    this.x_min = c.x;
                }
                if (c.z > this.z_max) {
                    this.z_max = c.z;
                }
                if (c.z >= this.z_min) continue;
                this.z_min = c.z;
            }
            this.x_dim = this.x_max - this.x_min + 1;
        }
        this.snapcnt = this.x_dim * (this.z_max - this.z_min + 1);
        this.snaparray = new Snapshot[this.snapcnt];
        this.inhabitedTicks = new long[this.snapcnt];
        this.snaptile = new DynIntHashMap[this.snapcnt];
        this.isSectionNotEmpty = new boolean[this.snapcnt][];
    }

    public abstract Snapshot wrapChunkSnapshot(ChunkSnapshot var1);

    @Override
    public int loadChunks(int max_to_load) {
        if (!this.dw.isLoaded()) {
            return 0;
        }
        Object queue = BukkitVersionHelper.helper.getUnloadQueue(this.w);
        int cnt = 0;
        if (this.iterator == null) {
            this.iterator = this.chunks.listIterator();
        }
        DynmapCore.setIgnoreChunkLoads(true);
        while (cnt < max_to_load && this.iterator.hasNext()) {
            boolean isunloadpending;
            boolean didload;
            boolean wasLoaded;
            SnapshotCache.SnapshotRec ssr;
            DynIntHashMap tileData;
            long inhabited_ticks;
            Snapshot ss;
            boolean vis;
            DynmapChunk chunk;
            long startTime;
            block32: {
                startTime = System.nanoTime();
                chunk = this.iterator.next();
                vis = true;
                if (this.visible_limits != null) {
                    vis = false;
                    for (VisibilityLimit limit : this.visible_limits) {
                        if (!limit.doIntersectChunk(chunk.x, chunk.z)) continue;
                        vis = true;
                        break;
                    }
                }
                if (vis && this.hidden_limits != null) {
                    for (VisibilityLimit limit : this.hidden_limits) {
                        if (!limit.doIntersectChunk(chunk.x, chunk.z)) continue;
                        vis = false;
                        break;
                    }
                }
                ss = null;
                inhabited_ticks = 0L;
                tileData = null;
                ssr = SnapshotCache.sscache.getSnapshot(this.dw.getName(), chunk.x, chunk.z, this.blockdata, this.biome, this.biomeraw, this.highesty);
                if (ssr != null) {
                    inhabited_ticks = ssr.inhabitedTicks;
                    ss = !vis ? (this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_STONE_PLAIN ? STONE : (this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_OCEAN ? OCEAN : EMPTY)) : ssr.ss;
                    int idx = chunk.x - this.x_min + (chunk.z - this.z_min) * this.x_dim;
                    this.snaparray[idx] = ss;
                    this.snaptile[idx] = ssr.tileData;
                    this.inhabitedTicks[idx] = inhabited_ticks;
                    this.endChunkLoad(startTime, MapChunkCache.ChunkStats.CACHED_SNAPSHOT_HIT);
                    continue;
                }
                wasLoaded = this.w.isChunkLoaded(chunk.x, chunk.z);
                didload = false;
                isunloadpending = false;
                if (queue != null) {
                    isunloadpending = BukkitVersionHelper.helper.isInUnloadQueue(queue, chunk.x, chunk.z);
                }
                if (isunloadpending) {
                    wasLoaded = true;
                }
                try {
                    didload = this.loadChunkNoGenerate(this.w, chunk.x, chunk.z);
                }
                catch (Throwable t) {
                    Log.warning("Bukkit error loading chunk " + chunk.x + "," + chunk.z + " on " + this.w.getName());
                    if (wasLoaded) break block32;
                    didload = this.w.isChunkLoaded(chunk.x, chunk.z);
                }
            }
            if (didload) {
                tileData = new DynIntHashMap();
                Chunk c = this.w.getChunkAt(chunk.x, chunk.z);
                inhabited_ticks = BukkitVersionHelper.helper.getInhabitedTicks(c);
                if (!vis) {
                    ss = this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_STONE_PLAIN ? STONE : (this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_OCEAN ? OCEAN : EMPTY);
                } else {
                    ChunkSnapshot css;
                    if (this.blockdata || this.highesty) {
                        css = c.getChunkSnapshot(this.highesty, this.biome, this.biomeraw);
                        ss = this.wrapChunkSnapshot(css);
                        ArrayList<Object> vals = new ArrayList<Object>();
                        Map<?, ?> tileents = BukkitVersionHelper.helper.getTileEntitiesForChunk(c);
                        for (Object t : tileents.values()) {
                            int te_z;
                            int cz;
                            int te_y;
                            int te_x = BukkitVersionHelper.helper.getTileEntityX(t);
                            int cx = te_x & 0xF;
                            String[] te_fields = HDBlockModels.getTileEntityFieldsNeeded(ss.getBlockType(cx, te_y = BukkitVersionHelper.helper.getTileEntityY(t), cz = (te_z = BukkitVersionHelper.helper.getTileEntityZ(t)) & 0xF));
                            if (te_fields == null) continue;
                            Object nbtcompound = BukkitVersionHelper.helper.readTileEntityNBT(t);
                            vals.clear();
                            for (String id : te_fields) {
                                Object val = BukkitVersionHelper.helper.getFieldValue(nbtcompound, id);
                                if (val == null) continue;
                                vals.add(id);
                                vals.add(val);
                            }
                            if (vals.size() <= 0) continue;
                            Object[] vlist = vals.toArray(new Object[vals.size()]);
                            tileData.put(AbstractMapChunkCache.getIndexInChunk(cx, te_y, cz), vlist);
                        }
                    } else {
                        css = this.w.getEmptyChunkSnapshot(chunk.x, chunk.z, this.biome, this.biomeraw);
                        ss = this.wrapChunkSnapshot(css);
                    }
                    if (ss != null) {
                        ssr = new SnapshotCache.SnapshotRec();
                        ssr.ss = ss;
                        ssr.inhabitedTicks = inhabited_ticks;
                        ssr.tileData = tileData;
                        SnapshotCache.sscache.putSnapshot(this.dw.getName(), chunk.x, chunk.z, ssr, this.blockdata, this.biome, this.biomeraw, this.highesty);
                    }
                }
                int chunkIndex = chunk.x - this.x_min + (chunk.z - this.z_min) * this.x_dim;
                this.snaparray[chunkIndex] = ss;
                this.snaptile[chunkIndex] = tileData;
                this.inhabitedTicks[chunkIndex] = inhabited_ticks;
                if (!wasLoaded) {
                    if (!this.w.isChunkInUse(chunk.x, chunk.z)) {
                        if (BukkitVersionHelper.helper.isUnloadChunkBroken()) {
                            this.w.unloadChunkRequest(chunk.x, chunk.z);
                        } else {
                            BukkitVersionHelper.helper.unloadChunkNoSave(this.w, c, chunk.x, chunk.z);
                        }
                    }
                    this.endChunkLoad(startTime, MapChunkCache.ChunkStats.UNLOADED_CHUNKS);
                } else if (isunloadpending) {
                    if (!this.w.isChunkInUse(chunk.x, chunk.z)) {
                        this.w.unloadChunkRequest(chunk.x, chunk.z);
                    }
                    this.endChunkLoad(startTime, MapChunkCache.ChunkStats.LOADED_CHUNKS);
                } else {
                    this.endChunkLoad(startTime, MapChunkCache.ChunkStats.LOADED_CHUNKS);
                }
            } else {
                this.endChunkLoad(startTime, MapChunkCache.ChunkStats.UNGENERATED_CHUNKS);
            }
            ++cnt;
        }
        DynmapCore.setIgnoreChunkLoads(false);
        if (!this.iterator.hasNext()) {
            this.isempty = true;
            for (int i = 0; i < this.snaparray.length; ++i) {
                if (this.snaparray[i] == null) {
                    this.snaparray[i] = EMPTY;
                    continue;
                }
                if (this.snaparray[i] == EMPTY) continue;
                this.isempty = false;
            }
        }
        return cnt;
    }

    @Override
    public boolean isDoneLoading() {
        if (!this.dw.isLoaded()) {
            this.isempty = true;
            this.unloadChunks();
            return true;
        }
        if (this.iterator != null) {
            return !this.iterator.hasNext();
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.isempty;
    }

    @Override
    public void unloadChunks() {
        if (this.snaparray != null) {
            for (int i = 0; i < this.snaparray.length; ++i) {
                this.snaparray[i] = null;
            }
            this.snaparray = null;
            this.inhabitedTicks = null;
        }
    }

    private void initSectionData(int idx) {
        this.isSectionNotEmpty[idx] = new boolean[this.nsect + 1];
        if (this.snaparray[idx] != EMPTY) {
            for (int i = 0; i < this.nsect; ++i) {
                if (this.snaparray[idx].isSectionEmpty(i)) continue;
                this.isSectionNotEmpty[idx][i] = true;
            }
        }
    }

    @Override
    public boolean isEmptySection(int sx, int sy, int sz) {
        int idx = sx - this.x_min + (sz - this.z_min) * this.x_dim;
        if (this.isSectionNotEmpty[idx] == null) {
            this.initSectionData(idx);
        }
        return !this.isSectionNotEmpty[idx][sy];
    }

    @Override
    public MapIterator getIterator(int x, int y, int z) {
        if (this.w.getEnvironment().toString().equals("THE_END")) {
            return new OurEndMapIterator(x, y, z);
        }
        return new BasetMapIterator(x, y, z);
    }

    @Override
    public void setHiddenFillStyle(MapChunkCache.HiddenChunkStyle style) {
        this.hidestyle = style;
    }

    @Override
    public void setVisibleRange(VisibilityLimit lim) {
        if (this.visible_limits == null) {
            this.visible_limits = new ArrayList<VisibilityLimit>();
        }
        this.visible_limits.add(lim);
    }

    @Override
    public void setHiddenRange(VisibilityLimit lim) {
        if (this.hidden_limits == null) {
            this.hidden_limits = new ArrayList<VisibilityLimit>();
        }
        this.hidden_limits.add(lim);
    }

    @Override
    public boolean setChunkDataTypes(boolean blockdata, boolean biome, boolean highestblocky, boolean rawbiome) {
        this.biome = biome;
        this.biomeraw = rawbiome;
        this.highesty = highestblocky;
        this.blockdata = blockdata;
        return true;
    }

    @Override
    public DynmapWorld getWorld() {
        return this.dw;
    }

    public boolean loadChunkNoGenerate(World w, int x, int z) {
        return w.loadChunk(x, z, false);
    }

    public static Biome getBiomeByID(int id) {
        if (id >= 0 && id < biome_by_id.length) {
            return biome_by_id[id];
        }
        return Biome.PLAINS;
    }

    static /* synthetic */ byte[][] access$102(AbstractMapChunkCache x0, byte[][] x1) {
        x0.sameneighborbiomecnt = x1;
        return x1;
    }

    static /* synthetic */ BiomeMap[][] access$302(AbstractMapChunkCache x0, BiomeMap[][] x1) {
        x0.biomemap = x1;
        return x1;
    }

    static {
        int i;
        init = false;
        nullBiomeMap = new BiomeMap[]{BiomeMap.NULL};
        unstep = new BlockStep[]{BlockStep.X_MINUS, BlockStep.Y_MINUS, BlockStep.Z_MINUS, BlockStep.X_PLUS, BlockStep.Y_PLUS, BlockStep.Z_PLUS};
        EMPTY = new EmptyChunk();
        STONE = new PlainChunk(DynmapBlockState.STONE_BLOCK);
        OCEAN = new PlainChunk(DynmapBlockState.WATER_BLOCK);
        Biome[] b = Biome.values();
        BiomeMap[] bm = BiomeMap.values();
        biome_to_bmap = new BiomeMap[1024];
        biome_by_id = new Biome[1024];
        Arrays.fill(biome_by_id, Biome.PLAINS);
        for (i = 0; i < biome_to_bmap.length; ++i) {
            AbstractMapChunkCache.biome_to_bmap[i] = BiomeMap.NULL;
        }
        block1: for (i = 0; i < b.length; ++i) {
            String bs = b[i].toString();
            for (int j = 0; j < bm.length; ++j) {
                if (!bm[j].toString().equals(bs)) continue;
                AbstractMapChunkCache.biome_to_bmap[b[i].ordinal()] = bm[j];
                AbstractMapChunkCache.biome_by_id[j] = b[i];
                continue block1;
            }
        }
    }

    private static class PlainChunk
    implements Snapshot {
        private DynmapBlockState fill;

        PlainChunk(String blockname) {
            this.fill = DynmapBlockState.getBaseStateByName(blockname);
        }

        @Override
        public final DynmapBlockState getBlockType(int x, int y, int z) {
            return y < 64 ? this.fill : DynmapBlockState.AIR;
        }

        @Override
        public Biome getBiome(int x, int z) {
            return null;
        }

        @Override
        public final int getBlockSkyLight(int x, int y, int z) {
            if (y < 64) {
                return 0;
            }
            return 15;
        }

        @Override
        public final int getBlockEmittedLight(int x, int y, int z) {
            return 0;
        }

        @Override
        public final int getHighestBlockYAt(int x, int z) {
            return 64;
        }

        @Override
        public boolean isSectionEmpty(int sy) {
            return sy < 4;
        }

        @Override
        public Object[] getBiomeBaseFromSnapshot() {
            return new Object[256];
        }
    }

    private static class EmptyChunk
    implements Snapshot {
        private EmptyChunk() {
        }

        @Override
        public final DynmapBlockState getBlockType(int x, int y, int z) {
            return DynmapBlockState.AIR;
        }

        @Override
        public final int getBlockSkyLight(int x, int y, int z) {
            return 15;
        }

        @Override
        public final int getBlockEmittedLight(int x, int y, int z) {
            return 0;
        }

        @Override
        public final int getHighestBlockYAt(int x, int z) {
            return 0;
        }

        @Override
        public Biome getBiome(int x, int z) {
            return null;
        }

        @Override
        public boolean isSectionEmpty(int sy) {
            return true;
        }

        @Override
        public Object[] getBiomeBaseFromSnapshot() {
            return new Object[256];
        }
    }

    private class OurEndMapIterator
    extends BasetMapIterator {
        OurEndMapIterator(int x0, int y0, int z0) {
            super(x0, y0, z0);
        }

        @Override
        public final int getBlockSkyLight() {
            return 15;
        }
    }

    public class BasetMapIterator
    implements MapIterator {
        private int x;
        private int y;
        private int z;
        private int chunkindex;
        private int bx;
        private int bz;
        private int off;
        private Snapshot snap;
        private BlockStep laststep;
        private DynmapBlockState type = null;
        private final int worldheight;
        private final int x_base;
        private final int z_base;

        BasetMapIterator(int x0, int y0, int z0) {
            this.x_base = AbstractMapChunkCache.this.x_min << 4;
            this.z_base = AbstractMapChunkCache.this.z_min << 4;
            if (AbstractMapChunkCache.this.biome) {
                this.biomePrep();
            }
            this.initialize(x0, y0, z0);
            this.worldheight = AbstractMapChunkCache.this.w.getMaxHeight();
        }

        @Override
        public final void initialize(int x0, int y0, int z0) {
            this.x = x0;
            this.y = y0;
            this.z = z0;
            this.chunkindex = (this.x >> 4) - AbstractMapChunkCache.this.x_min + ((this.z >> 4) - AbstractMapChunkCache.this.z_min) * AbstractMapChunkCache.this.x_dim;
            this.bx = this.x & 0xF;
            this.bz = this.z & 0xF;
            this.off = this.bx + (this.bz << 4);
            this.snap = this.chunkindex >= AbstractMapChunkCache.this.snapcnt || this.chunkindex < 0 ? EMPTY : AbstractMapChunkCache.this.snaparray[this.chunkindex];
            this.laststep = BlockStep.Y_MINUS;
            this.type = this.y >= 0 && this.y < this.worldheight ? null : DynmapBlockState.AIR;
        }

        @Override
        public final DynmapBlockState getBlockType() {
            if (this.type == null) {
                this.type = this.snap.getBlockType(this.bx, this.y, this.bz);
            }
            return this.type;
        }

        @Override
        public int getBlockSkyLight() {
            try {
                return this.snap.getBlockSkyLight(this.bx, this.y, this.bz);
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException runtimeException) {
                return 15;
            }
        }

        @Override
        public final int getBlockEmittedLight() {
            try {
                return this.snap.getBlockEmittedLight(this.bx, this.y, this.bz);
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException runtimeException) {
                return 0;
            }
        }

        private void biomePrep() {
            if (AbstractMapChunkCache.this.sameneighborbiomecnt != null) {
                return;
            }
            int x_size = AbstractMapChunkCache.this.x_dim << 4;
            int z_size = AbstractMapChunkCache.this.z_max - AbstractMapChunkCache.this.z_min + 1 << 4;
            AbstractMapChunkCache.access$102(AbstractMapChunkCache.this, new byte[x_size][]);
            AbstractMapChunkCache.access$302(AbstractMapChunkCache.this, new BiomeMap[x_size][]);
            for (int i = 0; i < x_size; ++i) {
                ((AbstractMapChunkCache)AbstractMapChunkCache.this).sameneighborbiomecnt[i] = new byte[z_size];
                ((AbstractMapChunkCache)AbstractMapChunkCache.this).biomemap[i] = new BiomeMap[z_size];
            }
            Snapshot last_css = null;
            Object[] biomebase = null;
            for (int i = 0; i < x_size; ++i) {
                for (int j = 0; j < z_size; ++j) {
                    Biome bb;
                    if (j == 0) {
                        this.initialize(i + this.x_base, 64, this.z_base);
                    } else {
                        this.stepPosition(BlockStep.Z_PLUS);
                    }
                    if (last_css != this.snap) {
                        biomebase = this.snap instanceof EmptyChunk || this.snap instanceof PlainChunk ? nullBiomeMap : this.snap.getBiomeBaseFromSnapshot();
                        last_css = this.snap;
                    }
                    BiomeMap bm = biomebase == nullBiomeMap ? BiomeMap.NULL : (biomebase != null ? BiomeMap.byBiomeID(BukkitVersionHelper.helper.getBiomeBaseID(biomebase[this.bz << 4 | this.bx])) : ((bb = this.snap.getBiome(this.bx, this.bz)) == null ? BiomeMap.NULL : biome_to_bmap[bb.ordinal()]));
                    ((AbstractMapChunkCache)AbstractMapChunkCache.this).biomemap[i][j] = bm;
                    int cnt = 0;
                    if (i > 0) {
                        if (bm == AbstractMapChunkCache.this.biomemap[i - 1][j]) {
                            ++cnt;
                            byte[] byArray = AbstractMapChunkCache.this.sameneighborbiomecnt[i - 1];
                            int n = j;
                            byArray[n] = (byte)(byArray[n] + 1);
                        }
                        if (j > 0 && bm == AbstractMapChunkCache.this.biomemap[i - 1][j - 1]) {
                            ++cnt;
                            byte[] byArray = AbstractMapChunkCache.this.sameneighborbiomecnt[i - 1];
                            int n = j - 1;
                            byArray[n] = (byte)(byArray[n] + 1);
                        }
                        if (j < z_size - 1 && bm == AbstractMapChunkCache.this.biomemap[i - 1][j + 1]) {
                            ++cnt;
                            byte[] byArray = AbstractMapChunkCache.this.sameneighborbiomecnt[i - 1];
                            int n = j + 1;
                            byArray[n] = (byte)(byArray[n] + 1);
                        }
                    }
                    if (j > 0 && AbstractMapChunkCache.this.biomemap[i][j] == AbstractMapChunkCache.this.biomemap[i][j - 1]) {
                        ++cnt;
                        byte[] byArray = AbstractMapChunkCache.this.sameneighborbiomecnt[i];
                        int n = j - 1;
                        byArray[n] = (byte)(byArray[n] + 1);
                    }
                    ((AbstractMapChunkCache)AbstractMapChunkCache.this).sameneighborbiomecnt[i][j] = (byte)cnt;
                }
            }
        }

        @Override
        public final BiomeMap getBiome() {
            try {
                return AbstractMapChunkCache.this.biomemap[this.x - this.x_base][this.z - this.z_base];
            }
            catch (Exception ex) {
                return BiomeMap.NULL;
            }
        }

        @Override
        public final int getSmoothGrassColorMultiplier(int[] colormap) {
            int mult = 0xFFFFFF;
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = AbstractMapChunkCache.this.biomemap[rx][rz];
                if (AbstractMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    mult = bm.getModifiedGrassMultiplier(colormap[bm.biomeLookup()]);
                } else {
                    int raccum = 0;
                    int gaccum = 0;
                    int baccum = 0;
                    for (int xoff = -1; xoff < 2; ++xoff) {
                        for (int zoff = -1; zoff < 2; ++zoff) {
                            bm = AbstractMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                            int rmult = bm.getModifiedGrassMultiplier(colormap[bm.biomeLookup()]);
                            raccum += rmult >> 16 & 0xFF;
                            gaccum += rmult >> 8 & 0xFF;
                            baccum += rmult & 0xFF;
                        }
                    }
                    mult = raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
                }
            }
            catch (Exception x) {
                mult = 0xFFFFFF;
            }
            return mult;
        }

        @Override
        public final int getSmoothFoliageColorMultiplier(int[] colormap) {
            int mult = 0xFFFFFF;
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = AbstractMapChunkCache.this.biomemap[rx][rz];
                if (AbstractMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    mult = bm.getModifiedFoliageMultiplier(colormap[bm.biomeLookup()]);
                } else {
                    int raccum = 0;
                    int gaccum = 0;
                    int baccum = 0;
                    for (int xoff = -1; xoff < 2; ++xoff) {
                        for (int zoff = -1; zoff < 2; ++zoff) {
                            bm = AbstractMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                            int rmult = bm.getModifiedFoliageMultiplier(colormap[bm.biomeLookup()]);
                            raccum += rmult >> 16 & 0xFF;
                            gaccum += rmult >> 8 & 0xFF;
                            baccum += rmult & 0xFF;
                        }
                    }
                    mult = raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
                }
            }
            catch (Exception x) {
                mult = 0xFFFFFF;
            }
            return mult;
        }

        @Override
        public final int getSmoothColorMultiplier(int[] colormap, int[] swampmap) {
            int mult = 0xFFFFFF;
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = AbstractMapChunkCache.this.biomemap[rx][rz];
                if (AbstractMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    mult = bm == BiomeMap.SWAMPLAND ? swampmap[bm.biomeLookup()] : colormap[bm.biomeLookup()];
                } else {
                    int raccum = 0;
                    int gaccum = 0;
                    int baccum = 0;
                    for (int xoff = -1; xoff < 2; ++xoff) {
                        for (int zoff = -1; zoff < 2; ++zoff) {
                            bm = AbstractMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                            int rmult = bm == BiomeMap.SWAMPLAND ? swampmap[bm.biomeLookup()] : colormap[bm.biomeLookup()];
                            raccum += rmult >> 16 & 0xFF;
                            gaccum += rmult >> 8 & 0xFF;
                            baccum += rmult & 0xFF;
                        }
                    }
                    mult = raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
                }
            }
            catch (Exception x) {
                mult = 0xFFFFFF;
            }
            return mult;
        }

        @Override
        public final int getSmoothWaterColorMultiplier() {
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = AbstractMapChunkCache.this.biomemap[rx][rz];
                if (AbstractMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    return bm.getWaterColorMult();
                }
                int raccum = 0;
                int gaccum = 0;
                int baccum = 0;
                for (int xoff = -1; xoff < 2; ++xoff) {
                    for (int zoff = -1; zoff < 2; ++zoff) {
                        bm = AbstractMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                        int mult = bm.getWaterColorMult();
                        raccum += mult >> 16 & 0xFF;
                        gaccum += mult >> 8 & 0xFF;
                        baccum += mult & 0xFF;
                    }
                }
                return raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
            }
            catch (Exception x) {
                return 0xFFFFFF;
            }
        }

        @Override
        public final int getSmoothWaterColorMultiplier(int[] colormap) {
            int mult = 0xFFFFFF;
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = AbstractMapChunkCache.this.biomemap[rx][rz];
                if (AbstractMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    mult = colormap[bm.biomeLookup()];
                } else {
                    int raccum = 0;
                    int gaccum = 0;
                    int baccum = 0;
                    for (int xoff = -1; xoff < 2; ++xoff) {
                        for (int zoff = -1; zoff < 2; ++zoff) {
                            bm = AbstractMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                            int rmult = colormap[bm.biomeLookup()];
                            raccum += rmult >> 16 & 0xFF;
                            gaccum += rmult >> 8 & 0xFF;
                            baccum += rmult & 0xFF;
                        }
                    }
                    mult = raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
                }
            }
            catch (Exception x) {
                Log.warning("Water colormult exception", x);
                mult = 0xFFFFFF;
            }
            return mult;
        }

        @Override
        public final void stepPosition(BlockStep step) {
            this.type = null;
            switch (step.ordinal()) {
                case 0: {
                    ++this.x;
                    ++this.bx;
                    ++this.off;
                    if (this.bx != 16) break;
                    this.bx = 0;
                    this.off -= 16;
                    ++this.chunkindex;
                    if (this.chunkindex >= AbstractMapChunkCache.this.snapcnt || this.chunkindex < 0) {
                        this.snap = EMPTY;
                        break;
                    }
                    this.snap = AbstractMapChunkCache.this.snaparray[this.chunkindex];
                    break;
                }
                case 1: {
                    ++this.y;
                    if (this.y < this.worldheight) break;
                    this.type = DynmapBlockState.AIR;
                    break;
                }
                case 2: {
                    ++this.z;
                    ++this.bz;
                    this.off += 16;
                    if (this.bz != 16) break;
                    this.bz = 0;
                    this.off -= 256;
                    this.chunkindex += AbstractMapChunkCache.this.x_dim;
                    if (this.chunkindex >= AbstractMapChunkCache.this.snapcnt || this.chunkindex < 0) {
                        this.snap = EMPTY;
                        break;
                    }
                    this.snap = AbstractMapChunkCache.this.snaparray[this.chunkindex];
                    break;
                }
                case 3: {
                    --this.x;
                    --this.bx;
                    --this.off;
                    if (this.bx != -1) break;
                    this.bx = 15;
                    this.off += 16;
                    --this.chunkindex;
                    if (this.chunkindex >= AbstractMapChunkCache.this.snapcnt || this.chunkindex < 0) {
                        this.snap = EMPTY;
                        break;
                    }
                    this.snap = AbstractMapChunkCache.this.snaparray[this.chunkindex];
                    break;
                }
                case 4: {
                    --this.y;
                    if (this.y >= 0) break;
                    this.type = DynmapBlockState.AIR;
                    break;
                }
                case 5: {
                    --this.z;
                    --this.bz;
                    this.off -= 16;
                    if (this.bz != -1) break;
                    this.bz = 15;
                    this.off += 256;
                    this.chunkindex -= AbstractMapChunkCache.this.x_dim;
                    this.snap = this.chunkindex >= AbstractMapChunkCache.this.snapcnt || this.chunkindex < 0 ? EMPTY : AbstractMapChunkCache.this.snaparray[this.chunkindex];
                }
            }
            this.laststep = step;
        }

        @Override
        public BlockStep unstepPosition() {
            BlockStep ls = this.laststep;
            this.stepPosition(unstep[ls.ordinal()]);
            return ls;
        }

        @Override
        public void unstepPosition(BlockStep s) {
            this.stepPosition(unstep[s.ordinal()]);
        }

        @Override
        public final void setY(int y) {
            this.laststep = y > this.y ? BlockStep.Y_PLUS : BlockStep.Y_MINUS;
            this.y = y;
            this.type = y < 0 || y >= this.worldheight ? DynmapBlockState.AIR : null;
        }

        @Override
        public final int getX() {
            return this.x;
        }

        @Override
        public final int getY() {
            return this.y;
        }

        @Override
        public final int getZ() {
            return this.z;
        }

        @Override
        public final DynmapBlockState getBlockTypeAt(BlockStep s) {
            if (s == BlockStep.Y_MINUS) {
                if (this.y > 0) {
                    return this.snap.getBlockType(this.bx, this.y - 1, this.bz);
                }
            } else if (s == BlockStep.Y_PLUS) {
                if (this.y < this.worldheight - 1) {
                    return this.snap.getBlockType(this.bx, this.y + 1, this.bz);
                }
            } else {
                BlockStep ls = this.laststep;
                this.stepPosition(s);
                DynmapBlockState tid = this.snap.getBlockType(this.bx, this.y, this.bz);
                this.unstepPosition();
                this.laststep = ls;
                return tid;
            }
            return DynmapBlockState.AIR;
        }

        @Override
        public BlockStep getLastStep() {
            return this.laststep;
        }

        @Override
        public int getWorldHeight() {
            return this.worldheight;
        }

        @Override
        public long getBlockKey() {
            return this.chunkindex * this.worldheight + this.y << 8 | this.bx << 4 | this.bz;
        }

        @Override
        public final boolean isEmptySection() {
            try {
                return !AbstractMapChunkCache.this.isSectionNotEmpty[this.chunkindex][this.y >> 4];
            }
            catch (Exception x) {
                AbstractMapChunkCache.this.initSectionData(this.chunkindex);
                return !AbstractMapChunkCache.this.isSectionNotEmpty[this.chunkindex][this.y >> 4];
            }
        }

        @Override
        public RenderPatchFactory getPatchFactory() {
            return HDBlockModels.getPatchDefinitionFactory();
        }

        @Override
        public Object getBlockTileEntityField(String fieldId) {
            try {
                int idx = AbstractMapChunkCache.getIndexInChunk(this.bx, this.y, this.bz);
                Object[] vals = (Object[])AbstractMapChunkCache.this.snaptile[this.chunkindex].get(idx);
                for (int i = 0; i < vals.length; i += 2) {
                    if (!vals[i].equals(fieldId)) continue;
                    return vals[i + 1];
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        public DynmapBlockState getBlockTypeAt(int xoff, int yoff, int zoff) {
            int xx = this.x + xoff;
            int yy = this.y + yoff;
            int zz = this.z + zoff;
            int idx = (xx >> 4) - AbstractMapChunkCache.this.x_min + ((zz >> 4) - AbstractMapChunkCache.this.z_min) * AbstractMapChunkCache.this.x_dim;
            try {
                return AbstractMapChunkCache.this.snaparray[idx].getBlockType(xx & 0xF, yy, zz & 0xF);
            }
            catch (Exception x) {
                return DynmapBlockState.AIR;
            }
        }

        @Override
        public Object getBlockTileEntityFieldAt(String fieldId, int xoff, int yoff, int zoff) {
            return null;
        }

        @Override
        public long getInhabitedTicks() {
            try {
                return AbstractMapChunkCache.this.inhabitedTicks[this.chunkindex];
            }
            catch (Exception x) {
                return 0L;
            }
        }
    }

    public static interface Snapshot {
        public DynmapBlockState getBlockType(int var1, int var2, int var3);

        public int getBlockSkyLight(int var1, int var2, int var3);

        public int getBlockEmittedLight(int var1, int var2, int var3);

        public int getHighestBlockYAt(int var1, int var2);

        public Biome getBiome(int var1, int var2);

        public boolean isSectionEmpty(int var1);

        public Object[] getBiomeBaseFromSnapshot();
    }
}

