/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.event.world.ChunkPopulateEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;
import org.dynmap.DynmapAPI;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapLocation;
import org.dynmap.DynmapWebChatEvent;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.MapManager;
import org.dynmap.MapType;
import org.dynmap.PlayerList;
import org.dynmap.bstats.bukkit.Metrics;
import org.dynmap.bukkit.Armor;
import org.dynmap.bukkit.Helper;
import org.dynmap.bukkit.SkinsRestorerSkinUrlProvider;
import org.dynmap.bukkit.helper.BukkitVersionHelper;
import org.dynmap.bukkit.helper.BukkitWorld;
import org.dynmap.bukkit.helper.SnapshotCache;
import org.dynmap.bukkit.permissions.BukkitPermissions;
import org.dynmap.bukkit.permissions.GroupManagerPermissions;
import org.dynmap.bukkit.permissions.LuckPerms5Permissions;
import org.dynmap.bukkit.permissions.LuckPermsPermissions;
import org.dynmap.bukkit.permissions.NijikokunPermissions;
import org.dynmap.bukkit.permissions.OpPermissions;
import org.dynmap.bukkit.permissions.PEXPermissions;
import org.dynmap.bukkit.permissions.PermBukkitPermissions;
import org.dynmap.bukkit.permissions.PermissionProvider;
import org.dynmap.bukkit.permissions.VaultPermissions;
import org.dynmap.bukkit.permissions.bPermPermissions;
import org.dynmap.common.BiomeMap;
import org.dynmap.common.DynmapCommandSender;
import org.dynmap.common.DynmapListenerManager;
import org.dynmap.common.DynmapPlayer;
import org.dynmap.common.DynmapServerInterface;
import org.dynmap.hdmap.HDMap;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.modsupport.ModSupportImpl;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.Polygon;
import org.dynmap.utils.VisibilityLimit;
import skinsrestorer.bukkit.SkinsRestorer;

public class DynmapPlugin
extends JavaPlugin
implements DynmapAPI {
    private DynmapCore core;
    private PermissionProvider permissions;
    private String version;
    public PlayerList playerList;
    private MapManager mapManager;
    public static DynmapPlugin plugin;
    public PluginManager pm;
    private Metrics metrics;
    private BukkitEnableCoreCallback enabCoreCB = new BukkitEnableCoreCallback();
    private Method ismodloaded;
    private Method instance;
    private Method getindexedmodlist;
    private Method getversion;
    private HashMap<String, BukkitWorld> world_by_name = new HashMap();
    private HashSet<String> modsused = new HashSet();
    private double tps;
    private long lasttick;
    private long perTickLimit;
    private long cur_tick_starttime;
    private long avgticklen = 50000000L;
    private int chunks_in_cur_tick = 0;
    private long cur_tick;
    private long prev_tick;
    private HashMap<String, Integer> sortWeights = new HashMap();
    private World last_world;
    private BukkitWorld last_bworld;
    private BukkitVersionHelper helper;
    private LinkedList<BlockToCheck> blocks_to_check = null;
    private LinkedList<BlockToCheck> blocks_to_check_accum = new LinkedList();
    private BlockCheckHandler btth = new BlockCheckHandler();
    private boolean onplace;
    private boolean onbreak;
    private boolean onblockform;
    private boolean onblockfade;
    private boolean onblockspread;
    private boolean onblockfromto;
    private boolean onblockphysics;
    private boolean onleaves;
    private boolean onburn;
    private boolean onpiston;
    private boolean onplayerjoin;
    private boolean onplayermove;
    private boolean ongeneratechunk;
    private boolean onexplosion;
    private boolean onstructuregrow;
    private boolean onblockgrow;
    private boolean onblockredstone;

    private final BukkitWorld getWorldByName(String name) {
        if (this.last_world != null && this.last_world.getName().equals(name)) {
            return this.last_bworld;
        }
        return this.world_by_name.get(name);
    }

    private final BukkitWorld getWorld(World w) {
        if (this.last_world == w) {
            return this.last_bworld;
        }
        BukkitWorld bw = this.world_by_name.get(w.getName());
        if (bw == null) {
            bw = new BukkitWorld(w);
            this.world_by_name.put(w.getName(), bw);
        } else if (!bw.isLoaded()) {
            bw.setWorldLoaded(w);
        }
        this.last_world = w;
        this.last_bworld = bw;
        return bw;
    }

    final void removeWorld(World w) {
        this.world_by_name.remove(w.getName());
        if (w == this.last_world) {
            this.last_world = null;
            this.last_bworld = null;
        }
    }

    public DynmapPlugin() {
        plugin = this;
        try {
            Class<?> c = Class.forName("cpw.mods.fml.common.Loader");
            this.ismodloaded = c.getMethod("isModLoaded", String.class);
            this.instance = c.getMethod("instance", new Class[0]);
            this.getindexedmodlist = c.getMethod("getIndexedModList", new Class[0]);
            c = Class.forName("cpw.mods.fml.common.ModContainer");
            this.getversion = c.getMethod("getVersion", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void loadExtraBiomes(String mcver) {
        int cnt = 0;
        BiomeMap.loadWellKnownByVersion(mcver);
        Object[] biomelist = this.helper.getBiomeBaseList();
        for (int i = 0; i < biomelist.length; ++i) {
            Object bb = biomelist[i];
            if (bb == null) continue;
            float tmp = this.helper.getBiomeBaseTemperature(bb);
            float hum = this.helper.getBiomeBaseHumidity(bb);
            int watermult = this.helper.getBiomeBaseWaterMult(bb);
            BiomeMap bmap = BiomeMap.byBiomeID(i);
            if (bmap.isDefault()) {
                String id = this.helper.getBiomeBaseIDString(bb);
                if (id == null) {
                    id = "BIOME_" + i;
                }
                bmap = new BiomeMap(i, id, tmp, hum);
                ++cnt;
            } else {
                bmap.setTemperature(tmp);
                bmap.setRainfall(hum);
            }
            if (watermult == -1) continue;
            bmap.setWaterColorMultiplier(watermult);
        }
        if (cnt > 0) {
            Log.info("Added " + cnt + " custom biome mappings");
        }
    }

    public void onLoad() {
        Log.setLogger(this.getLogger(), "");
        this.helper = Helper.getHelper();
        this.pm = this.getServer().getPluginManager();
        ModSupportImpl.init();
    }

    public void onEnable() {
        File dataDirectory;
        if (this.core != null && this.core.getMarkerAPI() != null) {
            this.getLogger().info("Starting Scheduled Write Job (markerAPI).");
            this.core.restartMarkerSaveJob();
        }
        if (this.helper == null) {
            Log.info("Dynmap is disabled (unsupported platform)");
            return;
        }
        PluginDescriptionFile pdfFile = this.getDescription();
        this.version = pdfFile.getVersion();
        String bukkitver = this.getServer().getVersion();
        String mcver = "1.0.0";
        int idx = bukkitver.indexOf("(MC: ");
        if (idx > 0 && (idx = (mcver = bukkitver.substring(idx + 5)).indexOf(")")) > 0) {
            mcver = mcver.substring(0, idx);
        }
        this.helper.initializeBlockStates();
        this.loadExtraBiomes(mcver);
        this.registerPlayerLoginListener();
        HashMap<String, Boolean> perdefs = new HashMap<String, Boolean>();
        List pd = plugin.getDescription().getPermissions();
        for (Permission p : pd) {
            perdefs.put(p.getName(), p.getDefault() == PermissionDefault.TRUE);
        }
        this.permissions = PEXPermissions.create(this.getServer(), "dynmap");
        if (this.permissions == null) {
            this.permissions = bPermPermissions.create(this.getServer(), "dynmap", perdefs);
        }
        if (this.permissions == null) {
            this.permissions = PermBukkitPermissions.create(this.getServer(), "dynmap", perdefs);
        }
        if (this.permissions == null) {
            this.permissions = NijikokunPermissions.create(this.getServer(), "dynmap");
        }
        if (this.permissions == null) {
            this.permissions = GroupManagerPermissions.create(this.getServer(), "dynmap");
        }
        if (this.permissions == null) {
            this.permissions = LuckPermsPermissions.create(this.getServer(), "dynmap");
        }
        if (this.permissions == null) {
            this.permissions = LuckPerms5Permissions.create(this.getServer(), "dynmap");
        }
        if (this.permissions == null) {
            this.permissions = VaultPermissions.create(this, "dynmap");
        }
        if (this.permissions == null) {
            this.permissions = BukkitPermissions.create("dynmap", perdefs);
        }
        if (this.permissions == null) {
            this.permissions = new OpPermissions(new String[]{"fullrender", "cancelrender", "radiusrender", "resetstats", "reload", "purgequeue", "pause", "ips-for-id", "ids-for-ip", "add-id-for-ip", "del-id-for-ip"});
        }
        if (!(dataDirectory = this.getDataFolder()).exists()) {
            dataDirectory.mkdirs();
        }
        if (this.core == null) {
            this.core = new DynmapCore();
        }
        this.core.setPluginJarFile(this.getFile());
        this.core.setPluginVersion(this.version, "CraftBukkit");
        this.core.setMinecraftVersion(mcver);
        this.core.setDataFolder(dataDirectory);
        this.core.setServer(new BukkitServer());
        this.core.setBiomeNames(this.helper.getBiomeNames());
        if (!this.core.initConfiguration(this.enabCoreCB)) {
            this.setEnabled(false);
            return;
        }
        SkinsRestorerSkinUrlProvider skinUrlProvider = null;
        if (this.core.configuration.getBoolean("skinsrestorer-integration", false)) {
            SkinsRestorer skinsRestorer = (SkinsRestorer)this.getServer().getPluginManager().getPlugin("SkinsRestorer");
            if (skinsRestorer == null) {
                Log.warning("SkinsRestorer integration can't be enabled because SkinsRestorer not installed");
            } else {
                skinUrlProvider = new SkinsRestorerSkinUrlProvider(skinsRestorer);
                Log.info("SkinsRestorer integration enabled");
            }
        }
        this.core.setSkinUrlProvider(skinUrlProvider);
        if (!this.readyToEnable()) {
            Listener pl = new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public void onPluginEnabled(PluginEnableEvent evt) {
                    if (!DynmapPlugin.this.readyToEnable() && DynmapPlugin.this.readyToEnable()) {
                        DynmapPlugin.this.doEnable();
                    }
                }
            };
            this.pm.registerEvents(pl, (Plugin)this);
        } else {
            this.doEnable();
        }
        this.lasttick = System.nanoTime();
        this.tps = 20.0;
        this.perTickLimit = this.core.getMaxTickUseMS() * 1000000;
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                DynmapPlugin.this.processTick();
            }
        }, 1L, 1L);
    }

    private boolean readyToEnable() {
        return true;
    }

    private void doEnable() {
        if (!this.core.enableCore(this.enabCoreCB)) {
            this.setEnabled(false);
            return;
        }
        this.playerList = this.core.playerList;
        SnapshotCache.sscache = new SnapshotCache(this.core.getSnapShotCacheSize(), this.core.useSoftRefInSnapShotCache());
        this.mapManager = this.core.getMapManager();
        for (World world : this.getServer().getWorlds()) {
            BukkitWorld w = this.getWorld(world);
            if (!this.core.processWorldLoad(w)) continue;
            this.core.listenerManager.processWorldEvent(DynmapListenerManager.EventType.WORLD_LOAD, w);
        }
        this.registerEvents();
        this.initMetrics();
        DynmapCommonAPIListener.apiInitialized(this);
        Log.info("Enabled");
    }

    public void onDisable() {
        DynmapCommonAPIListener.apiTerminated();
        if (this.metrics != null) {
            this.metrics = null;
        }
        this.core.disableCore();
        if (SnapshotCache.sscache != null) {
            SnapshotCache.sscache.cleanup();
            SnapshotCache.sscache = null;
        }
        Log.info("Disabled");
    }

    private void processTick() {
        long now = System.nanoTime();
        long elapsed = now - this.lasttick;
        this.lasttick = now;
        this.avgticklen = this.avgticklen * 99L / 100L + elapsed / 100L;
        this.tps = 1.0E9 / (double)this.avgticklen;
        if (this.mapManager != null) {
            this.chunks_in_cur_tick = this.mapManager.getMaxChunkLoadsPerTick();
        }
        ++this.cur_tick;
        if (this.core != null) {
            this.core.serverTick(this.tps);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        BukkitCommandSender dsender = sender instanceof Player ? new BukkitPlayer((Player)sender) : new BukkitCommandSender(sender);
        if (this.core != null) {
            return this.core.processCommand(dsender, cmd.getName(), commandLabel, args);
        }
        return false;
    }

    @Override
    public final MarkerAPI getMarkerAPI() {
        return this.core.getMarkerAPI();
    }

    @Override
    public final boolean markerAPIInitialized() {
        return this.core.markerAPIInitialized();
    }

    @Override
    public final boolean sendBroadcastToWeb(String sender, String msg) {
        return this.core.sendBroadcastToWeb(sender, msg);
    }

    @Override
    public final int triggerRenderOfVolume(String wid, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
        SnapshotCache.sscache.invalidateSnapshot(wid, minx, miny, minz, maxx, maxy, maxz);
        return this.core.triggerRenderOfVolume(wid, minx, miny, minz, maxx, maxy, maxz);
    }

    @Override
    public final int triggerRenderOfBlock(String wid, int x, int y, int z) {
        SnapshotCache.sscache.invalidateSnapshot(wid, x, y, z);
        return this.core.triggerRenderOfBlock(wid, x, y, z);
    }

    @Override
    public final void setPauseFullRadiusRenders(boolean dopause) {
        this.core.setPauseFullRadiusRenders(dopause);
    }

    @Override
    public final boolean getPauseFullRadiusRenders() {
        return this.core.getPauseFullRadiusRenders();
    }

    @Override
    public final void setPauseUpdateRenders(boolean dopause) {
        this.core.setPauseUpdateRenders(dopause);
    }

    @Override
    public final boolean getPauseUpdateRenders() {
        return this.core.getPauseUpdateRenders();
    }

    @Override
    public final void setPlayerVisiblity(String player, boolean is_visible) {
        this.core.setPlayerVisiblity(player, is_visible);
    }

    @Override
    public final boolean getPlayerVisbility(String player) {
        return this.core.getPlayerVisbility(player);
    }

    @Override
    public final void postPlayerMessageToWeb(String playerid, String playerdisplay, String message) {
        this.core.postPlayerMessageToWeb(playerid, playerdisplay, message);
    }

    @Override
    public final void postPlayerJoinQuitToWeb(String playerid, String playerdisplay, boolean isjoin) {
        this.core.postPlayerJoinQuitToWeb(playerid, playerdisplay, isjoin);
    }

    @Override
    public final String getDynmapCoreVersion() {
        return this.core.getDynmapCoreVersion();
    }

    @Override
    public final int triggerRenderOfVolume(Location l0, Location l1) {
        int x0 = l0.getBlockX();
        int y0 = l0.getBlockY();
        int z0 = l0.getBlockZ();
        int x1 = l1.getBlockX();
        int y1 = l1.getBlockY();
        int z1 = l1.getBlockZ();
        return this.core.triggerRenderOfVolume(this.getWorld(l0.getWorld()).getName(), Math.min(x0, x1), Math.min(y0, y1), Math.min(z0, z1), Math.max(x0, x1), Math.max(y0, y1), Math.max(z0, z1));
    }

    @Override
    public final void setPlayerVisiblity(Player player, boolean is_visible) {
        this.core.setPlayerVisiblity(player.getName(), is_visible);
    }

    @Override
    public final boolean getPlayerVisbility(Player player) {
        return this.core.getPlayerVisbility(player.getName());
    }

    @Override
    public final void postPlayerMessageToWeb(Player player, String message) {
        this.core.postPlayerMessageToWeb(player.getName(), player.getDisplayName(), message);
    }

    @Override
    public void postPlayerJoinQuitToWeb(Player player, boolean isjoin) {
        this.core.postPlayerJoinQuitToWeb(player.getName(), player.getDisplayName(), isjoin);
    }

    @Override
    public String getDynmapVersion() {
        return this.version;
    }

    private static DynmapLocation toLoc(Location l) {
        return new DynmapLocation(DynmapWorld.normalizeWorldName(l.getWorld().getName()), l.getBlockX(), l.getBlockY(), l.getBlockZ());
    }

    private void registerPlayerLoginListener() {
        Listener pl = new Listener(){

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public void onPlayerJoin(PlayerJoinEvent evt) {
                final BukkitPlayer dp = new BukkitPlayer(evt.getPlayer());
                DynmapPlugin.this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)DynmapPlugin.this, new Runnable(){

                    @Override
                    public void run() {
                        ((DynmapPlugin)DynmapPlugin.this).core.listenerManager.processPlayerEvent(DynmapListenerManager.EventType.PLAYER_JOIN, dp);
                    }
                }, 2L);
            }

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public void onPlayerQuit(PlayerQuitEvent evt) {
                BukkitPlayer dp = new BukkitPlayer(evt.getPlayer());
                ((DynmapPlugin)DynmapPlugin.this).core.listenerManager.processPlayerEvent(DynmapListenerManager.EventType.PLAYER_QUIT, dp);
            }
        };
        this.pm.registerEvents(pl, (Plugin)this);
    }

    private void checkBlock(Block b, String trigger) {
        BlockToCheck btt = new BlockToCheck();
        btt.loc = b.getLocation();
        btt.typeid = b.getTypeId();
        btt.data = b.getData();
        btt.trigger = trigger;
        this.blocks_to_check_accum.add(btt);
        this.btth.startIfNeeded();
    }

    private void registerEvents() {
        this.onplace = this.core.isTrigger("blockplaced");
        this.onbreak = this.core.isTrigger("blockbreak");
        this.onleaves = this.core.isTrigger("leavesdecay");
        this.onburn = this.core.isTrigger("blockburn");
        this.onblockform = this.core.isTrigger("blockformed");
        this.onblockfade = this.core.isTrigger("blockfaded");
        this.onblockspread = this.core.isTrigger("blockspread");
        this.onblockfromto = this.core.isTrigger("blockfromto");
        this.onblockphysics = this.core.isTrigger("blockphysics");
        this.onpiston = this.core.isTrigger("pistonmoved");
        this.onblockredstone = this.core.isTrigger("blockredstone");
        if (this.onplace) {
            Listener placelistener = new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public void onBlockPlace(BlockPlaceEvent event) {
                    Location loc = event.getBlock().getLocation();
                    String wn = DynmapPlugin.this.getWorld(loc.getWorld()).getName();
                    SnapshotCache.sscache.invalidateSnapshot(wn, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
                    DynmapPlugin.this.mapManager.touch(wn, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), "blockplace");
                }
            };
            this.pm.registerEvents(placelistener, (Plugin)this);
        }
        if (this.onbreak) {
            Listener breaklistener = new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public void onBlockBreak(BlockBreakEvent event) {
                    Block b = event.getBlock();
                    if (b == null) {
                        return;
                    }
                    Location loc = b.getLocation();
                    String wn = DynmapPlugin.this.getWorld(loc.getWorld()).getName();
                    SnapshotCache.sscache.invalidateSnapshot(wn, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
                    DynmapPlugin.this.mapManager.touch(wn, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), "blockbreak");
                }
            };
            this.pm.registerEvents(breaklistener, (Plugin)this);
        }
        if (this.onleaves) {
            Listener leaveslistener = new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public void onLeavesDecay(LeavesDecayEvent event) {
                    Location loc = event.getBlock().getLocation();
                    String wn = DynmapPlugin.this.getWorld(loc.getWorld()).getName();
                    SnapshotCache.sscache.invalidateSnapshot(wn, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
                    if (DynmapPlugin.this.onleaves) {
                        DynmapPlugin.this.mapManager.touch(wn, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), "leavesdecay");
                    }
                }
            };
            this.pm.registerEvents(leaveslistener, (Plugin)this);
        }
        if (this.onburn) {
            Listener burnlistener = new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public void onBlockBurn(BlockBurnEvent event) {
                    Location loc = event.getBlock().getLocation();
                    String wn = DynmapPlugin.this.getWorld(loc.getWorld()).getName();
                    SnapshotCache.sscache.invalidateSnapshot(wn, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
                    if (DynmapPlugin.this.onburn) {
                        DynmapPlugin.this.mapManager.touch(wn, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), "blockburn");
                    }
                }
            };
            this.pm.registerEvents(burnlistener, (Plugin)this);
        }
        if (this.onblockphysics) {
            Listener physlistener = new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public void onBlockPhysics(BlockPhysicsEvent event) {
                    Block b = event.getBlock();
                    Material m = b.getType();
                    if (m == null) {
                        return;
                    }
                    switch (m) {
                        case STATIONARY_WATER: 
                        case WATER: 
                        case STATIONARY_LAVA: 
                        case LAVA: 
                        case GRAVEL: 
                        case SAND: {
                            DynmapPlugin.this.checkBlock(b, "blockphysics");
                            break;
                        }
                    }
                }
            };
            this.pm.registerEvents(physlistener, (Plugin)this);
        }
        if (this.onblockfromto) {
            Listener fromtolistener = new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public void onBlockFromTo(BlockFromToEvent event) {
                    Block b = event.getBlock();
                    Material m = b.getType();
                    if (m != Material.WOOD_PLATE && m != Material.STONE_PLATE && m != null) {
                        DynmapPlugin.this.checkBlock(b, "blockfromto");
                    }
                    if ((m = (b = event.getToBlock()).getType()) != Material.WOOD_PLATE && m != Material.STONE_PLATE && m != null) {
                        DynmapPlugin.this.checkBlock(b, "blockfromto");
                    }
                }
            };
            this.pm.registerEvents(fromtolistener, (Plugin)this);
        }
        if (this.onpiston) {
            Listener pistonlistener = new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public void onBlockPistonRetract(BlockPistonRetractEvent event) {
                    BlockFace dir;
                    Block b = event.getBlock();
                    Location loc = b.getLocation();
                    try {
                        dir = event.getDirection();
                    }
                    catch (ClassCastException ccx) {
                        dir = BlockFace.NORTH;
                    }
                    String wn = DynmapPlugin.this.getWorld(loc.getWorld()).getName();
                    int x = loc.getBlockX();
                    int y = loc.getBlockY();
                    int z = loc.getBlockZ();
                    SnapshotCache.sscache.invalidateSnapshot(wn, x, y, z);
                    if (DynmapPlugin.this.onpiston) {
                        DynmapPlugin.this.mapManager.touch(wn, x, y, z, "pistonretract");
                    }
                    for (int i = 0; i < 2; ++i) {
                        SnapshotCache.sscache.invalidateSnapshot(wn, x += dir.getModX(), y += dir.getModY(), z += dir.getModZ());
                        DynmapPlugin.this.mapManager.touch(wn, x, y, z, "pistonretract");
                    }
                }

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public void onBlockPistonExtend(BlockPistonExtendEvent event) {
                    BlockFace dir;
                    Block b = event.getBlock();
                    Location loc = b.getLocation();
                    try {
                        dir = event.getDirection();
                    }
                    catch (ClassCastException ccx) {
                        dir = BlockFace.NORTH;
                    }
                    String wn = DynmapPlugin.this.getWorld(loc.getWorld()).getName();
                    int x = loc.getBlockX();
                    int y = loc.getBlockY();
                    int z = loc.getBlockZ();
                    SnapshotCache.sscache.invalidateSnapshot(wn, x, y, z);
                    if (DynmapPlugin.this.onpiston) {
                        DynmapPlugin.this.mapManager.touch(wn, x, y, z, "pistonretract");
                    }
                    for (int i = 0; i < 1 + event.getLength(); ++i) {
                        SnapshotCache.sscache.invalidateSnapshot(wn, x += dir.getModX(), y += dir.getModY(), z += dir.getModZ());
                        DynmapPlugin.this.mapManager.touch(wn, x, y, z, "pistonretract");
                    }
                }
            };
            this.pm.registerEvents(pistonlistener, (Plugin)this);
        }
        if (this.onblockspread) {
            Listener spreadlistener = new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public void onBlockSpread(BlockSpreadEvent event) {
                    Location loc = event.getBlock().getLocation();
                    String wn = DynmapPlugin.this.getWorld(loc.getWorld()).getName();
                    SnapshotCache.sscache.invalidateSnapshot(wn, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
                    DynmapPlugin.this.mapManager.touch(wn, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), "blockspread");
                }
            };
            this.pm.registerEvents(spreadlistener, (Plugin)this);
        }
        if (this.onblockform) {
            Listener formlistener = new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public void onBlockForm(BlockFormEvent event) {
                    Location loc = event.getBlock().getLocation();
                    String wn = DynmapPlugin.this.getWorld(loc.getWorld()).getName();
                    SnapshotCache.sscache.invalidateSnapshot(wn, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
                    DynmapPlugin.this.mapManager.touch(wn, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), "blockform");
                }
            };
            this.pm.registerEvents(formlistener, (Plugin)this);
        }
        if (this.onblockfade) {
            Listener fadelistener = new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public void onBlockFade(BlockFadeEvent event) {
                    Location loc = event.getBlock().getLocation();
                    String wn = DynmapPlugin.this.getWorld(loc.getWorld()).getName();
                    SnapshotCache.sscache.invalidateSnapshot(wn, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
                    DynmapPlugin.this.mapManager.touch(wn, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), "blockfade");
                }
            };
            this.pm.registerEvents(fadelistener, (Plugin)this);
        }
        this.onblockgrow = this.core.isTrigger("blockgrow");
        if (this.onblockgrow) {
            Listener growTrigger = new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public void onBlockGrow(BlockGrowEvent event) {
                    Location loc = event.getBlock().getLocation();
                    String wn = DynmapPlugin.this.getWorld(loc.getWorld()).getName();
                    SnapshotCache.sscache.invalidateSnapshot(wn, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
                    DynmapPlugin.this.mapManager.touch(wn, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), "blockgrow");
                }
            };
            this.pm.registerEvents(growTrigger, (Plugin)this);
        }
        if (this.onblockredstone) {
            Listener redstoneTrigger = new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public void onBlockRedstone(BlockRedstoneEvent event) {
                    Location loc = event.getBlock().getLocation();
                    String wn = DynmapPlugin.this.getWorld(loc.getWorld()).getName();
                    SnapshotCache.sscache.invalidateSnapshot(wn, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
                    DynmapPlugin.this.mapManager.touch(wn, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), "blockredstone");
                }
            };
            this.pm.registerEvents(redstoneTrigger, (Plugin)this);
        }
        Listener playerTrigger = new Listener(){

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public void onPlayerJoin(PlayerJoinEvent event) {
                if (DynmapPlugin.this.onplayerjoin) {
                    Location loc = event.getPlayer().getLocation();
                    DynmapPlugin.this.mapManager.touch(DynmapPlugin.this.getWorld(loc.getWorld()).getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), "playerjoin");
                }
            }
        };
        this.onplayerjoin = this.core.isTrigger("playerjoin");
        this.onplayermove = this.core.isTrigger("playermove");
        this.pm.registerEvents(playerTrigger, (Plugin)this);
        if (this.onplayermove) {
            Listener playermove = new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public void onPlayerMove(PlayerMoveEvent event) {
                    Location loc = event.getPlayer().getLocation();
                    DynmapPlugin.this.mapManager.touch(DynmapPlugin.this.getWorld(loc.getWorld()).getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), "playermove");
                }
            };
            this.pm.registerEvents(playermove, (Plugin)this);
            Log.warning("playermove trigger enabled - this trigger can cause excessive tile updating: use with caution");
        }
        Listener entityTrigger = new Listener(){

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public void onEntityExplode(EntityExplodeEvent event) {
                int maxz;
                int maxy;
                int maxx;
                Location loc = event.getLocation();
                String wname = DynmapPlugin.this.getWorld(loc.getWorld()).getName();
                int minx = maxx = loc.getBlockX();
                int miny = maxy = loc.getBlockY();
                int minz = maxz = loc.getBlockZ();
                List blocks = event.blockList();
                for (Block b : blocks) {
                    int z;
                    int y;
                    Location l = b.getLocation();
                    int x = l.getBlockX();
                    if (x < minx) {
                        minx = x;
                    }
                    if (x > maxx) {
                        maxx = x;
                    }
                    if ((y = l.getBlockY()) < miny) {
                        miny = y;
                    }
                    if (y > maxy) {
                        maxy = y;
                    }
                    if ((z = l.getBlockZ()) < minz) {
                        minz = z;
                    }
                    if (z <= maxz) continue;
                    maxz = z;
                }
                SnapshotCache.sscache.invalidateSnapshot(wname, minx, miny, minz, maxx, maxy, maxz);
                if (DynmapPlugin.this.onexplosion) {
                    DynmapPlugin.this.mapManager.touchVolume(wname, minx, miny, minz, maxx, maxy, maxz, "entityexplode");
                }
            }
        };
        this.onexplosion = this.core.isTrigger("explosion");
        this.pm.registerEvents(entityTrigger, (Plugin)this);
        Listener worldTrigger = new Listener(){

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public void onWorldLoad(WorldLoadEvent event) {
                BukkitWorld w = DynmapPlugin.this.getWorld(event.getWorld());
                if (DynmapPlugin.this.core.processWorldLoad(w)) {
                    ((DynmapPlugin)DynmapPlugin.this).core.listenerManager.processWorldEvent(DynmapListenerManager.EventType.WORLD_LOAD, w);
                }
            }

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public void onWorldUnload(WorldUnloadEvent event) {
                BukkitWorld w = DynmapPlugin.this.getWorld(event.getWorld());
                if (w != null) {
                    ((DynmapPlugin)DynmapPlugin.this).core.listenerManager.processWorldEvent(DynmapListenerManager.EventType.WORLD_UNLOAD, w);
                    w.setWorldUnloaded();
                    DynmapPlugin.this.core.processWorldUnload(w);
                }
            }

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public void onStructureGrow(StructureGrowEvent event) {
                int maxz;
                int maxy;
                int maxx;
                Location loc = event.getLocation();
                String wname = DynmapPlugin.this.getWorld(loc.getWorld()).getName();
                int minx = maxx = loc.getBlockX();
                int miny = maxy = loc.getBlockY();
                int minz = maxz = loc.getBlockZ();
                List blocks = event.getBlocks();
                for (BlockState b : blocks) {
                    int z;
                    int y;
                    int x = b.getX();
                    if (x < minx) {
                        minx = x;
                    }
                    if (x > maxx) {
                        maxx = x;
                    }
                    if ((y = b.getY()) < miny) {
                        miny = y;
                    }
                    if (y > maxy) {
                        maxy = y;
                    }
                    if ((z = b.getZ()) < minz) {
                        minz = z;
                    }
                    if (z <= maxz) continue;
                    maxz = z;
                }
                SnapshotCache.sscache.invalidateSnapshot(wname, minx, miny, minz, maxx, maxy, maxz);
                if (DynmapPlugin.this.onstructuregrow) {
                    DynmapPlugin.this.mapManager.touchVolume(wname, minx, miny, minz, maxx, maxy, maxz, "structuregrow");
                }
            }
        };
        this.onstructuregrow = this.core.isTrigger("structuregrow");
        this.pm.registerEvents(worldTrigger, (Plugin)this);
        this.ongeneratechunk = this.core.isTrigger("chunkgenerated");
        if (this.ongeneratechunk) {
            Listener chunkTrigger = new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public void onChunkPopulate(ChunkPopulateEvent event) {
                    Chunk c = event.getChunk();
                    ChunkSnapshot cs = c.getChunkSnapshot();
                    int ymax = 0;
                    for (int i = 0; i < c.getWorld().getMaxHeight() / 16; ++i) {
                        if (cs.isSectionEmpty(i)) continue;
                        ymax = (i + 1) * 16;
                    }
                    int x = c.getX() << 4;
                    int z = c.getZ() << 4;
                    DynmapPlugin.this.mapManager.touchVolume(DynmapPlugin.this.getWorld(event.getWorld()).getName(), x, 0, z, x + 15, ymax, z + 16, "chunkpopulate");
                }
            };
            this.pm.registerEvents(chunkTrigger, (Plugin)this);
        }
    }

    @Override
    public void assertPlayerInvisibility(String player, boolean is_invisible, String plugin_id) {
        this.core.assertPlayerInvisibility(player, is_invisible, plugin_id);
    }

    @Override
    public void assertPlayerInvisibility(Player player, boolean is_invisible, Plugin plugin) {
        this.core.assertPlayerInvisibility(player.getName(), is_invisible, plugin.getDescription().getName());
    }

    @Override
    public void assertPlayerVisibility(String player, boolean is_visible, String plugin_id) {
        this.core.assertPlayerVisibility(player, is_visible, plugin_id);
    }

    @Override
    public void assertPlayerVisibility(Player player, boolean is_visible, Plugin plugin) {
        this.core.assertPlayerVisibility(player.getName(), is_visible, plugin.getDescription().getName());
    }

    @Override
    public boolean setDisableChatToWebProcessing(boolean disable) {
        return this.core.setDisableChatToWebProcessing(disable);
    }

    @Override
    public boolean testIfPlayerVisibleToPlayer(String player, String player_to_see) {
        return this.core.testIfPlayerVisibleToPlayer(player, player_to_see);
    }

    @Override
    public boolean testIfPlayerInfoProtected() {
        return this.core.testIfPlayerInfoProtected();
    }

    private void initMetrics() {
        this.metrics = new Metrics((Plugin)this);
        this.metrics.addCustomChart(new Metrics.MultiLineChart("features_used", () -> {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            hashMap.put("internal_web_server", this.core.configuration.getBoolean("disable-webserver", false) ? 0 : 1);
            hashMap.put("login_security", this.core.configuration.getBoolean("login-enabled", false) ? 1 : 0);
            hashMap.put("player_info_protected", this.core.player_info_protected ? 1 : 0);
            for (String mod : this.modsused) {
                hashMap.put(mod + "_blocks", 1);
            }
            return hashMap;
        }));
        this.metrics.addCustomChart(new Metrics.MultiLineChart("map_data", () -> {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            hashMap.put("worlds", this.core.mapManager != null ? this.core.mapManager.getWorlds().size() : 0);
            int maps = 0;
            int hdmaps = 0;
            if (this.core.mapManager != null) {
                for (DynmapWorld w : this.core.mapManager.getWorlds()) {
                    for (MapType mt : w.maps) {
                        if (!(mt instanceof HDMap)) continue;
                        ++hdmaps;
                    }
                    maps += w.maps.size();
                }
            }
            hashMap.put("maps", maps);
            hashMap.put("hd_maps", hdmaps);
            return hashMap;
        }));
    }

    @Override
    public void processSignChange(String material, String world, int x, int y, int z, String[] lines, String playerid) {
        this.core.processSignChange(material, world, x, y, z, lines, playerid);
    }

    Polygon getWorldBorder(World w) {
        return this.helper.getWorldBorder(w);
    }

    public static boolean migrateChunks() {
        if (plugin != null && DynmapPlugin.plugin.core != null) {
            DynmapPlugin dynmapPlugin = plugin;
            return dynmapPlugin.core.migrateChunks();
        }
        return false;
    }

    private class BlockCheckHandler
    implements Runnable {
        private BlockCheckHandler() {
        }

        @Override
        public void run() {
            while (!DynmapPlugin.this.blocks_to_check.isEmpty()) {
                BlockToCheck btt = (BlockToCheck)DynmapPlugin.this.blocks_to_check.pop();
                Location loc = btt.loc;
                World w = loc.getWorld();
                if (!w.isChunkLoaded(loc.getBlockX() >> 4, loc.getBlockZ() >> 4)) continue;
                int bt = w.getBlockTypeIdAt(loc);
                if (bt == 9) {
                    bt = 8;
                }
                if (btt.typeid == 9) {
                    btt.typeid = 8;
                }
                if (bt == btt.typeid && btt.data == w.getBlockAt(loc).getData()) continue;
                String wn = DynmapPlugin.this.getWorld(w).getName();
                SnapshotCache.sscache.invalidateSnapshot(wn, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
                DynmapPlugin.this.mapManager.touch(wn, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), btt.trigger);
            }
            DynmapPlugin.this.blocks_to_check = null;
            this.startIfNeeded();
        }

        public void startIfNeeded() {
            if (DynmapPlugin.this.blocks_to_check == null && !DynmapPlugin.this.blocks_to_check_accum.isEmpty()) {
                DynmapPlugin.this.blocks_to_check = DynmapPlugin.this.blocks_to_check_accum;
                DynmapPlugin.this.blocks_to_check_accum = new LinkedList();
                DynmapPlugin.this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)DynmapPlugin.this, (Runnable)this, 10L);
            }
        }
    }

    public class BukkitCommandSender
    implements DynmapCommandSender {
        private CommandSender sender;

        public BukkitCommandSender(CommandSender send) {
            this.sender = send;
        }

        @Override
        public boolean hasPrivilege(String privid) {
            if (this.sender != null) {
                return DynmapPlugin.this.permissions.has(this.sender, privid);
            }
            return false;
        }

        @Override
        public void sendMessage(String msg) {
            if (this.sender != null) {
                this.sender.sendMessage(msg);
            }
        }

        @Override
        public boolean isConnected() {
            return this.sender != null;
        }

        @Override
        public boolean isOp() {
            if (this.sender != null) {
                return this.sender.isOp();
            }
            return false;
        }

        @Override
        public boolean hasPermissionNode(String node) {
            if (this.sender != null) {
                return this.sender.hasPermission(node);
            }
            return false;
        }
    }

    public class BukkitPlayer
    extends BukkitCommandSender
    implements DynmapPlayer {
        private Player player;
        private OfflinePlayer offplayer;
        private String skinurl;
        private UUID uuid;

        public BukkitPlayer(Player p) {
            super((CommandSender)p);
            this.player = p;
            this.offplayer = p.getPlayer();
            this.uuid = p.getUniqueId();
            this.skinurl = DynmapPlugin.this.helper.getSkinURL(p);
        }

        public BukkitPlayer(OfflinePlayer p) {
            super(null);
            this.offplayer = p;
        }

        @Override
        public boolean isConnected() {
            return this.offplayer.isOnline();
        }

        @Override
        public String getName() {
            return this.offplayer.getName();
        }

        @Override
        public String getDisplayName() {
            if (this.player != null) {
                return this.player.getDisplayName();
            }
            return this.offplayer.getName();
        }

        @Override
        public boolean isOnline() {
            return this.offplayer.isOnline();
        }

        @Override
        public DynmapLocation getLocation() {
            if (this.player == null) {
                return null;
            }
            Location loc = this.player.getEyeLocation();
            return DynmapPlugin.toLoc(loc);
        }

        @Override
        public String getWorld() {
            if (this.player == null) {
                return null;
            }
            World w = this.player.getWorld();
            if (w != null) {
                return DynmapPlugin.this.getWorld(w).getName();
            }
            return null;
        }

        @Override
        public InetSocketAddress getAddress() {
            if (this.player != null) {
                return this.player.getAddress();
            }
            return null;
        }

        @Override
        public boolean isSneaking() {
            if (this.player != null) {
                return this.player.isSneaking();
            }
            return false;
        }

        @Override
        public double getHealth() {
            if (this.player != null) {
                return Math.ceil(2.0 * this.player.getHealth() / this.player.getMaxHealth() * this.player.getHealthScale()) / 2.0;
            }
            return 0.0;
        }

        @Override
        public int getArmorPoints() {
            if (this.player != null) {
                return Armor.getArmorPoints(this.player);
            }
            return 0;
        }

        @Override
        public DynmapLocation getBedSpawnLocation() {
            Location loc = this.offplayer.getBedSpawnLocation();
            if (loc != null) {
                return DynmapPlugin.toLoc(loc);
            }
            return null;
        }

        @Override
        public long getLastLoginTime() {
            return this.offplayer.getLastPlayed();
        }

        @Override
        public long getFirstLoginTime() {
            return this.offplayer.getFirstPlayed();
        }

        @Override
        public boolean isInvisible() {
            if (this.player != null) {
                return this.player.hasPotionEffect(PotionEffectType.INVISIBILITY);
            }
            return false;
        }

        @Override
        public int getSortWeight() {
            Integer wt = (Integer)DynmapPlugin.this.sortWeights.get(this.getName());
            if (wt != null) {
                return wt;
            }
            return 0;
        }

        @Override
        public void setSortWeight(int wt) {
            if (wt == 0) {
                DynmapPlugin.this.sortWeights.remove(this.getName());
            } else {
                DynmapPlugin.this.sortWeights.put(this.getName(), wt);
            }
        }

        @Override
        public String getSkinURL() {
            return this.skinurl;
        }

        @Override
        public UUID getUUID() {
            return this.uuid;
        }

        @Override
        public void sendTitleText(String title, String subtitle, int fadeInTicks, int stayTicks, int fadeOutTIcks) {
            if (this.player != null) {
                DynmapPlugin.this.helper.sendTitleText(this.player, title, subtitle, fadeInTicks, stayTicks, fadeOutTIcks);
            }
        }
    }

    public class BukkitServer
    extends DynmapServerInterface {
        private boolean noservername = false;
        private Set<DynmapListenerManager.EventType> registered = new HashSet<DynmapListenerManager.EventType>();

        @Override
        public int getBlockIDAt(String wname, int x, int y, int z) {
            World w = DynmapPlugin.this.getServer().getWorld(wname);
            if (w != null && w.isChunkLoaded(x >> 4, z >> 4)) {
                return w.getBlockTypeIdAt(x, y, z);
            }
            return -1;
        }

        @Override
        public int isSignAt(String wname, int x, int y, int z) {
            World w = DynmapPlugin.this.getServer().getWorld(wname);
            if (w != null && w.isChunkLoaded(x >> 4, z >> 4)) {
                Block b = w.getBlockAt(x, y, z);
                BlockState s = b.getState();
                if (s instanceof Sign) {
                    return 1;
                }
                return 0;
            }
            return -1;
        }

        @Override
        public void scheduleServerTask(Runnable run, long delay) {
            DynmapPlugin.this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)DynmapPlugin.this, run, delay);
        }

        @Override
        public DynmapPlayer[] getOnlinePlayers() {
            Player[] players = DynmapPlugin.this.helper.getOnlinePlayers();
            DynmapPlayer[] dplay = new DynmapPlayer[players.length];
            for (int i = 0; i < players.length; ++i) {
                dplay[i] = new BukkitPlayer(players[i]);
            }
            return dplay;
        }

        @Override
        public void reload() {
            PluginManager pluginManager = DynmapPlugin.this.getServer().getPluginManager();
            pluginManager.disablePlugin((Plugin)DynmapPlugin.this);
            pluginManager.enablePlugin((Plugin)DynmapPlugin.this);
        }

        @Override
        public DynmapPlayer getPlayer(String name) {
            Player p = DynmapPlugin.this.getServer().getPlayerExact(name);
            if (p != null) {
                return new BukkitPlayer(p);
            }
            return null;
        }

        @Override
        public Set<String> getIPBans() {
            return DynmapPlugin.this.getServer().getIPBans();
        }

        @Override
        public <T> Future<T> callSyncMethod(Callable<T> task) {
            if (DynmapPlugin.this.isEnabled()) {
                return DynmapPlugin.this.getServer().getScheduler().callSyncMethod((Plugin)DynmapPlugin.this, task);
            }
            return null;
        }

        @Override
        public String getServerName() {
            try {
                if (!this.noservername) {
                    return DynmapPlugin.this.getServer().getServerName();
                }
            }
            catch (NoSuchMethodError x) {
                this.noservername = true;
            }
            return DynmapPlugin.this.getServer().getMotd();
        }

        @Override
        public boolean isPlayerBanned(String pid) {
            OfflinePlayer p = DynmapPlugin.this.getServer().getOfflinePlayer(pid);
            return p != null && p.isBanned();
        }

        @Override
        public boolean isServerThread() {
            return Bukkit.getServer().isPrimaryThread();
        }

        @Override
        public String stripChatColor(String s) {
            return ChatColor.stripColor((String)s);
        }

        @Override
        public boolean requestEventNotification(DynmapListenerManager.EventType type) {
            if (this.registered.contains((Object)type)) {
                return true;
            }
            switch (type) {
                case WORLD_LOAD: 
                case WORLD_UNLOAD: {
                    break;
                }
                case WORLD_SPAWN_CHANGE: {
                    DynmapPlugin.this.pm.registerEvents(new Listener(){

                        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                        public void onSpawnChange(SpawnChangeEvent evt) {
                            BukkitWorld w = DynmapPlugin.this.getWorld(evt.getWorld());
                            ((DynmapPlugin)DynmapPlugin.this).core.listenerManager.processWorldEvent(DynmapListenerManager.EventType.WORLD_SPAWN_CHANGE, w);
                        }
                    }, (Plugin)DynmapPlugin.this);
                    break;
                }
                case PLAYER_JOIN: 
                case PLAYER_QUIT: {
                    break;
                }
                case PLAYER_BED_LEAVE: {
                    DynmapPlugin.this.pm.registerEvents(new Listener(){

                        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                        public void onPlayerBedLeave(PlayerBedLeaveEvent evt) {
                            BukkitPlayer p = new BukkitPlayer(evt.getPlayer());
                            ((DynmapPlugin)DynmapPlugin.this).core.listenerManager.processPlayerEvent(DynmapListenerManager.EventType.PLAYER_BED_LEAVE, p);
                        }
                    }, (Plugin)DynmapPlugin.this);
                    break;
                }
                case PLAYER_CHAT: {
                    DynmapPlugin.this.pm.registerEvents(new Listener(){

                        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                        public void onPlayerChat(AsyncPlayerChatEvent evt) {
                            final Player p = evt.getPlayer();
                            final String msg = evt.getMessage();
                            DynmapPlugin.this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)DynmapPlugin.this, new Runnable(){

                                @Override
                                public void run() {
                                    BukkitPlayer dp = null;
                                    if (p != null) {
                                        dp = new BukkitPlayer(p);
                                    }
                                    ((DynmapPlugin)DynmapPlugin.this).core.listenerManager.processChatEvent(DynmapListenerManager.EventType.PLAYER_CHAT, dp, msg);
                                }
                            });
                        }
                    }, (Plugin)DynmapPlugin.this);
                    break;
                }
                case BLOCK_BREAK: {
                    DynmapPlugin.this.pm.registerEvents(new Listener(){

                        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                        public void onBlockBreak(BlockBreakEvent evt) {
                            Block b = evt.getBlock();
                            if (b == null) {
                                return;
                            }
                            Location l = b.getLocation();
                            ((DynmapPlugin)DynmapPlugin.this).core.listenerManager.processBlockEvent(DynmapListenerManager.EventType.BLOCK_BREAK, b.getType().name(), DynmapPlugin.this.getWorld(l.getWorld()).getName(), l.getBlockX(), l.getBlockY(), l.getBlockZ());
                        }
                    }, (Plugin)DynmapPlugin.this);
                    break;
                }
                case SIGN_CHANGE: {
                    DynmapPlugin.this.pm.registerEvents(new Listener(){

                        @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
                        public void onSignChange(SignChangeEvent evt) {
                            Block b = evt.getBlock();
                            Location l = b.getLocation();
                            String[] lines = evt.getLines();
                            BukkitPlayer dp = null;
                            Player p = evt.getPlayer();
                            if (p != null) {
                                dp = new BukkitPlayer(p);
                            }
                            ((DynmapPlugin)DynmapPlugin.this).core.listenerManager.processSignChangeEvent(DynmapListenerManager.EventType.SIGN_CHANGE, b.getType().name(), DynmapPlugin.this.getWorld(l.getWorld()).getName(), l.getBlockX(), l.getBlockY(), l.getBlockZ(), lines, dp);
                        }
                    }, (Plugin)DynmapPlugin.this);
                    break;
                }
                default: {
                    Log.severe("Unhandled event type: " + (Object)((Object)type));
                    return false;
                }
            }
            this.registered.add(type);
            return true;
        }

        @Override
        public boolean sendWebChatEvent(String source, String name, String msg) {
            DynmapWebChatEvent evt = new DynmapWebChatEvent(source, name, msg);
            DynmapPlugin.this.getServer().getPluginManager().callEvent((Event)evt);
            return !evt.isCancelled() && !evt.isProcessed();
        }

        @Override
        public void broadcastMessage(String msg) {
            DynmapPlugin.this.getServer().broadcastMessage(msg);
        }

        @Override
        public String[] getBiomeIDs() {
            BiomeMap[] b = BiomeMap.values();
            String[] bname = new String[b.length];
            for (int i = 0; i < bname.length; ++i) {
                bname[i] = b[i].toString();
            }
            return bname;
        }

        @Override
        public double getCacheHitRate() {
            return SnapshotCache.sscache.getHitRate();
        }

        @Override
        public void resetCacheStats() {
            SnapshotCache.sscache.resetStats();
        }

        @Override
        public DynmapWorld getWorldByName(String wname) {
            return DynmapPlugin.this.getWorldByName(wname);
        }

        @Override
        public DynmapPlayer getOfflinePlayer(String name) {
            OfflinePlayer op = DynmapPlugin.this.getServer().getOfflinePlayer(name);
            if (op != null) {
                return new BukkitPlayer(op);
            }
            return null;
        }

        @Override
        public Set<String> checkPlayerPermissions(String player, Set<String> perms) {
            OfflinePlayer p = DynmapPlugin.this.getServer().getOfflinePlayer(player);
            if (p.isBanned()) {
                return new HashSet<String>();
            }
            Set<String> rslt = DynmapPlugin.this.permissions.hasOfflinePermissions(player, perms);
            if (rslt == null) {
                rslt = new HashSet<String>();
                if (p.isOp()) {
                    rslt.addAll(perms);
                }
            }
            return rslt;
        }

        @Override
        public boolean checkPlayerPermission(String player, String perm) {
            OfflinePlayer p = DynmapPlugin.this.getServer().getOfflinePlayer(player);
            if (p.isBanned()) {
                return false;
            }
            boolean rslt = DynmapPlugin.this.permissions.hasOfflinePermission(player, perm);
            return rslt;
        }

        @Override
        public MapChunkCache createMapChunkCache(DynmapWorld w, List<DynmapChunk> chunks, boolean blockdata, boolean highesty, boolean biome, boolean rawbiome) {
            MapChunkCache c = w.getChunkCache(chunks);
            if (c == null) {
                return null;
            }
            if (w.visibility_limits != null) {
                for (VisibilityLimit limit : w.visibility_limits) {
                    c.setVisibleRange(limit);
                }
                c.setHiddenFillStyle(w.hiddenchunkstyle);
            }
            if (w.hidden_limits != null) {
                for (VisibilityLimit limit : w.hidden_limits) {
                    c.setHiddenRange(limit);
                }
                c.setHiddenFillStyle(w.hiddenchunkstyle);
            }
            if (!c.setChunkDataTypes(blockdata, biome, highesty, rawbiome)) {
                Log.severe("CraftBukkit build does not support biome APIs");
            }
            if (chunks.size() == 0) {
                c.loadChunks(0);
                return c;
            }
            final MapChunkCache cc = c;
            while (!cc.isDoneLoading()) {
                Boolean delay;
                Future<Boolean> f = DynmapPlugin.this.core.getServer().callSyncMethod(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        boolean exhausted = true;
                        if (DynmapPlugin.this.prev_tick != DynmapPlugin.this.cur_tick) {
                            DynmapPlugin.this.prev_tick = DynmapPlugin.this.cur_tick;
                            DynmapPlugin.this.cur_tick_starttime = System.nanoTime();
                        }
                        if (DynmapPlugin.this.chunks_in_cur_tick > 0) {
                            boolean done = false;
                            while (!done) {
                                int cnt = DynmapPlugin.this.chunks_in_cur_tick;
                                if (cnt > 5) {
                                    cnt = 5;
                                }
                                DynmapPlugin.this.chunks_in_cur_tick = DynmapPlugin.this.chunks_in_cur_tick - cc.loadChunks(cnt);
                                exhausted = DynmapPlugin.this.chunks_in_cur_tick == 0 || System.nanoTime() - DynmapPlugin.this.cur_tick_starttime > DynmapPlugin.this.perTickLimit;
                                done = exhausted || cc.isDoneLoading();
                            }
                        }
                        return exhausted;
                    }
                });
                if (f == null) {
                    return null;
                }
                try {
                    delay = f.get();
                }
                catch (CancellationException cx) {
                    return null;
                }
                catch (ExecutionException ex) {
                    Log.severe("Exception while fetching chunks: ", ex.getCause());
                    return null;
                }
                catch (Exception ix) {
                    Log.severe(ix);
                    return null;
                }
                if (delay == null || !delay.booleanValue()) continue;
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!w.isLoaded()) {
                return null;
            }
            return c;
        }

        @Override
        public int getMaxPlayers() {
            return DynmapPlugin.this.getServer().getMaxPlayers();
        }

        @Override
        public int getCurrentPlayers() {
            return DynmapPlugin.this.helper.getOnlinePlayers().length;
        }

        @Override
        public boolean isModLoaded(String name) {
            if (DynmapPlugin.this.ismodloaded != null) {
                try {
                    Object rslt = DynmapPlugin.this.ismodloaded.invoke(null, name);
                    if (rslt instanceof Boolean && ((Boolean)rslt).booleanValue()) {
                        DynmapPlugin.this.modsused.add(name);
                        return true;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public String getModVersion(String name) {
            if (DynmapPlugin.this.instance != null && DynmapPlugin.this.getindexedmodlist != null && DynmapPlugin.this.getversion != null) {
                try {
                    Object inst = DynmapPlugin.this.instance.invoke(null, new Object[0]);
                    Map modmap = (Map)DynmapPlugin.this.getindexedmodlist.invoke(inst, new Object[0]);
                    Object mod = modmap.get(name);
                    if (mod != null) {
                        return (String)DynmapPlugin.this.getversion.invoke(mod, new Object[0]);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public double getServerTPS() {
            return DynmapPlugin.this.tps;
        }

        @Override
        public String getServerIP() {
            return Bukkit.getServer().getIp();
        }

        @Override
        public Map<Integer, String> getBlockIDMap() {
            String[] bsn = DynmapPlugin.this.helper.getBlockNames();
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            for (int i = 0; i < bsn.length; ++i) {
                if (bsn[i] == null) continue;
                if (bsn[i].indexOf(58) < 0) {
                    map.put(i, "minecraft:" + bsn[i]);
                    continue;
                }
                map.put(i, bsn[i]);
            }
            return map;
        }
    }

    private static class BlockToCheck {
        Location loc;
        int typeid;
        byte data;
        String trigger;

        private BlockToCheck() {
        }
    }

    private class BukkitEnableCoreCallback
    extends DynmapCore.EnableCoreCallbacks {
        private BukkitEnableCoreCallback() {
        }

        @Override
        public void configurationLoaded() {
            File st = new File(DynmapPlugin.this.core.getDataFolder(), "renderdata/spout-texture.txt");
            if (st.exists()) {
                st.delete();
            }
        }
    }
}

